/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.climate;

import java.util.Random;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.util.chunk.ClimateChunk;
import mod.bespectacled.modernbetaforge.util.noise.SimplexOctaveNoise;
import net.minecraft.util.math.MathHelper;

public class BetaClimateSampler {
    private final SimplexOctaveNoise tempNoiseOctaves;
    private final SimplexOctaveNoise rainNoiseOctaves;
    private final SimplexOctaveNoise detailNoiseOctaves;
    private final ChunkCache<ClimateChunk> climateCache;
    private final double tempScale;
    private final double rainScale;
    private final double detailScale;

    public BetaClimateSampler(long seed) {
        this(seed, 1.0, 1.0, 1.0);
    }

    public BetaClimateSampler(long seed, double tempScale, double rainScale, double detailScale) {
        this.tempNoiseOctaves = new SimplexOctaveNoise(new Random(seed * 9871L), 4);
        this.rainNoiseOctaves = new SimplexOctaveNoise(new Random(seed * 39811L), 4);
        this.detailNoiseOctaves = new SimplexOctaveNoise(new Random(seed * 543321L), 2);
        this.climateCache = new ChunkCache<ClimateChunk>("climate", 512, true, (chunkX, chunkZ) -> new ClimateChunk((int)chunkX, (int)chunkZ, this::sampleClimateNoise));
        this.tempScale = (double)0.025f / tempScale;
        this.rainScale = (double)0.05f / rainScale;
        this.detailScale = 0.25 / detailScale;
    }

    public Clime sampleClime(int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.climateCache.get(chunkX, chunkZ).sampleClime(x, z);
    }

    public Clime sampleClimateNoise(int x, int z) {
        double temp = this.tempNoiseOctaves.sample(x, z, this.tempScale, this.tempScale, 0.25);
        double rain = this.rainNoiseOctaves.sample(x, z, this.rainScale, this.rainScale, 0.3333333333333333);
        double detail = this.detailNoiseOctaves.sample(x, z, this.detailScale, this.detailScale, 0.5882352941176471);
        detail = detail * 1.1 + 0.5;
        temp = (temp * 0.15 + 0.7) * 0.99 + detail * 0.01;
        rain = (rain * 0.15 + 0.5) * 0.998 + detail * 0.002;
        temp = 1.0 - (1.0 - temp) * (1.0 - temp);
        return new Clime(MathHelper.func_151237_a((double)temp, (double)0.0, (double)1.0), MathHelper.func_151237_a((double)rain, (double)0.0, (double)1.0));
    }
}

