/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.beta;

import java.util.Random;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.world.biome.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeBetaPlains
extends BiomeBeta {
    public BiomeBetaPlains() {
        super(new Biome.BiomeProperties("Beta Plains").func_185410_a(1.0f).func_185395_b(0.4f));
        this.field_76752_A = BlockStates.GRASS_BLOCK;
        this.field_76753_B = BlockStates.DIRT;
        if (ModernBetaConfig.mobOptions.useNewMobs) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 5, 2, 6));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 3));
        }
        this.skyColor = 6733055;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random random, BlockPos blockPos) {
        double flowerNoise = Biome.field_180281_af.func_151601_a((double)blockPos.func_177958_n() / 200.0, (double)blockPos.func_177952_p() / 200.0);
        if (flowerNoise > -0.2) {
            int randFlower = random.nextInt(4);
            switch (randFlower) {
                case 0: {
                    return BlockFlower.EnumFlowerType.ORANGE_TULIP;
                }
                case 1: {
                    return BlockFlower.EnumFlowerType.RED_TULIP;
                }
                case 2: {
                    return BlockFlower.EnumFlowerType.PINK_TULIP;
                }
            }
            return BlockFlower.EnumFlowerType.WHITE_TULIP;
        }
        return random.nextInt(3) == 1 ? BlockFlower.EnumFlowerType.HOUSTONIA : BlockFlower.EnumFlowerType.OXEYE_DAISY;
    }

    public void func_180624_a(World world, Random random, BlockPos startPos) {
        super.func_180624_a(world, random, startPos);
        ModernBetaChunkGeneratorSettings settings = ModernBetaChunkGeneratorSettings.Factory.jsonToFactory(world.func_72912_H().func_82571_y()).build();
        ChunkPos chunkPos = new ChunkPos(startPos);
        if (settings.useNewFlowers && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int i = 0; i < 4; ++i) {
                int dY;
                BlockPos blockPos;
                BlockFlower.EnumFlowerType enumFlowerType;
                BlockFlower blockFlower;
                int dZ;
                int dX = random.nextInt(16) + 8;
                int height = world.func_175645_m(startPos.func_177982_a(dX, 0, dZ = random.nextInt(16) + 8)).func_177956_o() + 32;
                if (height <= 0 || (blockFlower = (enumFlowerType = this.func_180623_a(random, blockPos = startPos.func_177982_a(dX, dY = random.nextInt(height), dZ))).func_176964_a().func_180346_a()).func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.field_76760_I.field_150514_p.func_175914_a(blockFlower, enumFlowerType);
                this.field_76760_I.field_150514_p.func_180709_b(world, random, blockPos);
            }
        }
    }
}

