/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.beta;

import java.util.Iterator;
import java.util.Random;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.world.biome.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeBetaDesert
extends BiomeBeta {
    public BiomeBetaDesert() {
        super(new Biome.BiomeProperties("Beta Desert").func_185410_a(1.0f).func_185395_b(0.0f).func_185396_a());
        this.field_76752_A = BlockStates.SAND;
        this.field_76753_B = BlockStates.SAND;
        this.field_76762_K.clear();
        if (ModernBetaConfig.mobOptions.useNewMobs) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
            Iterator monsterIterator = this.field_76761_J.iterator();
            while (monsterIterator.hasNext()) {
                Biome.SpawnListEntry spawnListEntry = (Biome.SpawnListEntry)monsterIterator.next();
                if (spawnListEntry.field_76300_b != EntityZombie.class && spawnListEntry.field_76300_b != EntityZombieVillager.class) continue;
                monsterIterator.remove();
            }
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombie.class, 19, 4, 4));
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombieVillager.class, 1, 1, 1));
            this.field_76761_J.add(new Biome.SpawnListEntry(EntityHusk.class, 80, 4, 4));
        }
        this.skyColor = 6733055;
    }

    public void func_180624_a(World world, Random random, BlockPos startPos) {
        super.func_180624_a(world, random, startPos);
        ModernBetaChunkGeneratorSettings settings = ModernBetaChunkGeneratorSettings.Factory.jsonToFactory(world.func_72912_H().func_82571_y()).build();
        ChunkPos chunkPos = new ChunkPos(startPos);
        if (settings.useDesertWells && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DESERT_WELL) && random.nextInt(1000) == 0) {
            int x = random.nextInt(16) + 8;
            int z = random.nextInt(16) + 8;
            BlockPos structurePos = world.func_175645_m(startPos.func_177982_a(x, 0, z)).func_177984_a();
            new WorldGenDesertWells().func_180709_b(world, random, structurePos);
        }
        if (settings.useFossils && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && random.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(world, random, startPos);
        }
    }
}

