/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.beta;

import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.beta.BiomeDecoratorBeta;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiomeBeta
extends ModernBetaBiome {
    protected static final WorldGenBirchTree BIRCH_TREE_FEATURE = new WorldGenBirchTree(false, false);
    protected static final WorldGenTaiga1 PINE_FEATURE_1 = new WorldGenTaiga1();
    protected static final WorldGenTaiga2 PINE_FEATURE_2 = new WorldGenTaiga2(false);
    protected int skyColor = -1;

    public BiomeBeta(Biome.BiomeProperties properties) {
        super(properties);
    }

    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new BiomeDecoratorBeta());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        BlockPos blockPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        if (BetaColorSampler.INSTANCE.canSampleSkyColor()) {
            return BetaColorSampler.INSTANCE.getSkyColor(blockPos);
        }
        if (this.skyColor != -1) {
            return this.skyColor;
        }
        return super.func_76731_a(temp);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos blockPos) {
        if (BetaColorSampler.INSTANCE.canSampleBiomeColor()) {
            return BetaColorSampler.INSTANCE.getGrassColor(blockPos);
        }
        return super.func_180627_b(blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos blockPos) {
        if (BetaColorSampler.INSTANCE.canSampleBiomeColor()) {
            return BetaColorSampler.INSTANCE.getFoliageColor(blockPos);
        }
        return super.func_180625_c(blockPos);
    }

    public static boolean canSetIce(World world, BlockPos blockPos, boolean doWaterCheck, double temp) {
        if (temp >= 0.5) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, blockPos) < 10) {
            boolean isWater;
            IBlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean bl = isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
            if (isWater && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                boolean submerged;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl2 = submerged = BiomeBeta.isWater(world, blockPos.func_177976_e()) && BiomeBeta.isWater(world, blockPos.func_177974_f()) && BiomeBeta.isWater(world, blockPos.func_177978_c()) && BiomeBeta.isWater(world, blockPos.func_177968_d());
                if (!submerged) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canSetSnow(World world, BlockPos blockPos, double temp) {
        IBlockState blockState;
        if (temp >= 0.5) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, blockPos) < 10 && (blockState = world.func_180495_p(blockPos)).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos) && Blocks.field_150431_aC.func_176196_c(world, blockPos);
    }

    private static boolean isWater(World world, BlockPos blockPos) {
        return world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h;
    }
}

