/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSourceType;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSource;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.storage.WorldInfo;

public class ModernBetaBiomeProvider
extends BiomeProvider {
    private final BiomeSource biomeSource;
    private ChunkSource chunkSource;

    public ModernBetaBiomeProvider(WorldInfo worldInfo) {
        super(worldInfo);
        ModernBetaChunkGeneratorSettings settings = worldInfo.func_82571_y() != null ? ModernBetaChunkGeneratorSettings.Factory.jsonToFactory(worldInfo.func_82571_y()).build() : new ModernBetaChunkGeneratorSettings.Factory().build();
        this.biomeSource = BiomeSourceType.fromId(settings.biomeSource).create(worldInfo);
        this.chunkSource = null;
    }

    public Biome[] func_76937_a(Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ) {
        return this.func_76931_a(biomes, startX >> 2, startZ >> 2, sizeX, sizeZ, true);
    }

    public Biome[] func_76933_b(@Nullable Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ) {
        return this.func_76931_a(biomes, startX, startZ, sizeX, sizeZ, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomes, int startX, int startZ, int sizeX, int sizeZ, boolean cacheFlag) {
        if (biomes == null || biomes.length != sizeX * sizeZ) {
            biomes = new Biome[sizeX * sizeZ];
        }
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                biomes[localX + localZ * 16] = this.getBiome(x, z);
            }
        }
        return biomes;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> allowed, Random random) {
        int minX = x - range >> 2;
        int maxX = x + range >> 2;
        int minZ = z - range >> 2;
        int maxZ = z + range >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        BlockPos blockPos = null;
        int j = 0;
        for (int i = 0; i < sizeX * sizeZ; ++i) {
            int startX = minX + i % sizeX << 2;
            int startZ = minZ + i / sizeX << 2;
            Biome biome = this.biomeSource.getBiome(startX, startZ);
            if (!allowed.contains(biome) || blockPos != null && random.nextInt(j + 1) != 0) continue;
            blockPos = new BlockPos(startX, 0, startZ);
            ++j;
        }
        return blockPos;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        if (radius == 0) {
            return allowed.contains(this.getBiome(x, z));
        }
        double r2 = radius * radius;
        for (int dX = x - radius; dX < x + radius; ++dX) {
            for (int dZ = z - radius; dZ < z + radius; ++dZ) {
                Biome biome;
                double distance = MathUtil.distance(x, z, dX, dZ);
                if (!(distance < r2) || allowed.contains(biome = this.getBiome(dX, dZ))) continue;
                return false;
            }
        }
        return true;
    }

    public BiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    public void setChunkSource(ChunkSource chunkSource) {
        this.chunkSource = chunkSource;
    }

    private Biome getBiome(int x, int z) {
        Biome biome;
        Biome biome2 = biome = this.chunkSource != null ? this.chunkSource.getInjectedBiomeFast(x, z) : this.biomeSource.getBiome(x, z);
        if (biome == null) {
            biome = this.biomeSource.getBiome(x, z);
        }
        return biome;
    }
}

