/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.chunk;

public class HeightmapChunk {
    private final short[] heightmapSurface;
    private final short[] heightmapOcean;
    private final short[] heightmapFloor;

    public HeightmapChunk(short[] heightmapSurface, short[] heightmapOcean, short[] heightmapFloor) {
        if (heightmapSurface.length != 256 || heightmapOcean.length != 256 || heightmapFloor.length != 256) {
            throw new IllegalArgumentException("[Modern Beta] Heightmap is an invalid size!");
        }
        this.heightmapSurface = heightmapSurface;
        this.heightmapOcean = heightmapOcean;
        this.heightmapFloor = heightmapFloor;
    }

    public int getHeight(int x, int z, Type type) {
        short height;
        int ndx = (z & 0xF) + (x & 0xF) * 16;
        switch (type) {
            case SURFACE: {
                height = this.heightmapSurface[ndx];
                break;
            }
            case OCEAN: {
                height = this.heightmapOcean[ndx];
                break;
            }
            case FLOOR: {
                height = this.heightmapFloor[ndx];
                break;
            }
            default: {
                height = this.heightmapSurface[ndx];
            }
        }
        return height;
    }

    public static enum Type {
        SURFACE,
        OCEAN,
        FLOOR;

    }
}

