/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.event;

import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSource;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DebugInfoEventHandler {
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_71356_B() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            BiomeSource biomeSource;
            IntegratedServer integratedServer = minecraft.func_71401_C();
            MinecraftServer minecraftServer = integratedServer.func_184102_h();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldServer worldServer = (WorldServer)minecraftServer.func_130014_f_();
            if (player.field_71093_bK != DimensionType.OVERWORLD.func_186068_a()) {
                return;
            }
            IChunkGenerator chunkGenerator = worldServer.func_72863_F().field_186029_c;
            BiomeProvider biomeProvider = worldServer.func_72959_q();
            BlockPos playerPos = player.func_180425_c();
            int x = playerPos.func_177958_n();
            int z = playerPos.func_177952_p();
            event.getLeft().add("");
            if (biomeProvider instanceof ModernBetaBiomeProvider && (biomeSource = ((ModernBetaBiomeProvider)biomeProvider).getBiomeSource()) instanceof ClimateSampler) {
                ClimateSampler climateSampler = (ClimateSampler)((Object)biomeSource);
                Clime clime = climateSampler.sample(x, z);
                double temp = clime.temp();
                double rain = clime.rain();
                String climateText = String.format("[Modern Beta] Climate Temp: %.3f Rainfall: %.3f", temp, rain);
                String originalBiomeText = String.format("[Modern Beta] Original biome: %s", biomeSource.getBiome(x, z).func_185359_l());
                event.getLeft().add(climateText);
                event.getLeft().add(originalBiomeText);
            }
            if (chunkGenerator instanceof ModernBetaChunkGenerator) {
                ChunkSource chunkSource = ((ModernBetaChunkGenerator)chunkGenerator).getChunkSource();
                String heightmapText = String.format("[Modern Beta] Surface Height: %d Ocean Height: %d Floor Height: %d", chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE), chunkSource.getHeight(x, z, HeightmapChunk.Type.OCEAN), chunkSource.getHeight(x, z, HeightmapChunk.Type.FLOOR));
                String seaLevelText = String.format("[Modern Beta] Sea level: %d", chunkSource.getSeaLevel());
                event.getLeft().add(heightmapText);
                event.getLeft().add(seaLevelText);
            }
        }
    }
}

