/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="modernbetaforge")
public class ModernBetaConfig {
    public static CategoryGenerator generatorOptions = new CategoryGenerator();
    public static CategoryVisual visualOptions = new CategoryVisual();
    public static CategoryMob mobOptions = new CategoryMob();
    public static CategorySpawn spawnOptions = new CategorySpawn();

    @Mod.EventBusSubscriber(modid="modernbetaforge")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("modernbetaforge")) {
                ConfigManager.sync((String)"modernbetaforge", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class CategorySpawn {
        @Config.Comment(value={"Use spawn fuzz for players who join the world"})
        @Config.RequiresMcRestart
        public boolean useSpawnFuzz = false;
    }

    public static class CategoryMob {
        @Config.Comment(value={"Use new mobs when initializing Beta biomes"})
        @Config.RequiresMcRestart
        public boolean useNewMobs = true;
    }

    public static class CategoryVisual {
        @Config.Comment(value={"Render Beta-accurate biome colors"})
        @Config.RequiresWorldRestart
        public boolean useBetaBiomeColors = true;
        @Config.Comment(value={"Render Beta-accurate sky colors"})
        @Config.RequiresWorldRestart
        public boolean useBetaSkyColors = true;
        @Config.Comment(value={"Render old sugar cane colors"})
        @Config.RequiresWorldRestart
        public boolean useOldSugarCaneColor = false;
        @Config.Comment(value={"Modern Beta world cloud height"})
        @Config.RangeInt(min=0, max=255)
        @Config.RequiresMcRestart
        public int cloudHeight = 108;
    }

    public static class CategoryGenerator {
        @Config.Comment(value={"Add biomes with custom surface builders for compatibility, requires fully-qualified biome registry name"})
        @Config.RequiresMcRestart
        public String[] biomesWithCustomSurfaces = new String[0];
    }
}

