/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSourceType;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSourceType;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizePresets;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@SideOnly(value=Side.CLIENT)
public class GuiCustomizeWorldScreen
extends GuiScreen
implements GuiSlider.FormatHelper,
GuiPageButtonList.GuiResponder {
    private static final float MAX_HEIGHT = 255.0f;
    private static final float MIN_BIOME_SCALE = 0.1f;
    private static final float MAX_BIOME_SCALE = 8.0f;
    private final GuiCreateWorld parent;
    protected String title = "Customize World Settings";
    protected String subtitle = "Page 1 of 3";
    protected String pageTitle = "Basic Settings";
    protected String[] pageNames = new String[4];
    private GuiPageButtonList pageList;
    private GuiButton done;
    private GuiButton randomize;
    private GuiButton defaults;
    private GuiButton previousPage;
    private GuiButton nextPage;
    private GuiButton confirm;
    private GuiButton cancel;
    private GuiButton presets;
    private boolean settingsModified;
    private int confirmMode;
    private boolean confirmDismissed;
    private final Predicate<String> floatFilter = new Predicate<String>(){

        public boolean apply(@Nullable String entryString) {
            Float entryValue = Floats.tryParse((String)entryString);
            return entryString.isEmpty() || entryValue != null && Floats.isFinite((float)entryValue.floatValue()) && entryValue.floatValue() >= 0.0f;
        }
    };
    private final Predicate<String> intFilter = new Predicate<String>(){

        public boolean apply(@Nullable String entryString) {
            Integer entryValue = Ints.tryParse((String)entryString);
            return entryString.isEmpty() || entryValue != null && entryValue >= 0 && entryValue <= 255;
        }
    };
    private final ModernBetaChunkGeneratorSettings.Factory defaultSettings = new ModernBetaChunkGeneratorSettings.Factory();
    private ModernBetaChunkGeneratorSettings.Factory settings;
    private final Random random = new Random();

    public GuiCustomizeWorldScreen(GuiScreen guiScreen, String string) {
        this.parent = (GuiCreateWorld)guiScreen;
        this.loadValues(string);
    }

    private void createPagedList() {
        IForgeRegistry biomes = ForgeRegistries.BIOMES;
        int biomeId = biomes.getValues().indexOf(biomes.getValue(new ResourceLocation(this.settings.fixedBiome)));
        int chunkSourceId = Arrays.asList(ChunkSourceType.values()).indexOf((Object)ChunkSourceType.fromId(this.settings.chunkSource));
        int biomeSourceId = Arrays.asList(BiomeSourceType.values()).indexOf((Object)BiomeSourceType.fromId(this.settings.biomeSource));
        GuiPageButtonList.GuiListEntry[] pageList0 = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiSlideEntry(700, I18n.func_135052_a((String)"createWorld.customize.custom.chunkSource", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, (float)(ChunkSourceType.values().length - 1), (float)chunkSourceId), new GuiPageButtonList.GuiSlideEntry(701, I18n.func_135052_a((String)"createWorld.customize.custom.biomeSource", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, (float)(BiomeSourceType.values().length - 1), (float)biomeSourceId), new GuiPageButtonList.GuiLabelEntry(702, I18n.func_135052_a((String)"createWorld.customize.custom.fixedBiomeLabel", (Object[])new Object[0]), true), new GuiPageButtonList.GuiSlideEntry(162, I18n.func_135052_a((String)"createWorld.customize.custom.fixedBiome", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, (float)(biomes.getValues().size() - 1), (float)biomeId), new GuiPageButtonList.GuiLabelEntry(510, I18n.func_135052_a((String)"createWorld.customize.custom.betaLabel", (Object[])new Object[0]), true), null, new GuiPageButtonList.GuiButtonEntry(500, I18n.func_135052_a((String)"createWorld.customize.custom.replaceOceanBiomes", (Object[])new Object[0]), true, this.settings.replaceOceanBiomes), new GuiPageButtonList.GuiButtonEntry(501, I18n.func_135052_a((String)"createWorld.customize.custom.replaceBeachBiomes", (Object[])new Object[0]), true, this.settings.replaceBeachBiomes), new GuiPageButtonList.GuiButtonEntry(502, I18n.func_135052_a((String)"createWorld.customize.custom.useTallGrass", (Object[])new Object[0]), true, this.settings.useTallGrass), new GuiPageButtonList.GuiButtonEntry(503, I18n.func_135052_a((String)"createWorld.customize.custom.useNewFlowers", (Object[])new Object[0]), true, this.settings.useNewFlowers), new GuiPageButtonList.GuiButtonEntry(504, I18n.func_135052_a((String)"createWorld.customize.custom.useLilyPads", (Object[])new Object[0]), true, this.settings.useLilyPads), new GuiPageButtonList.GuiButtonEntry(505, I18n.func_135052_a((String)"createWorld.customize.custom.useMelons", (Object[])new Object[0]), true, this.settings.useMelons), new GuiPageButtonList.GuiButtonEntry(506, I18n.func_135052_a((String)"createWorld.customize.custom.useDesertWells", (Object[])new Object[0]), true, this.settings.useDesertWells), new GuiPageButtonList.GuiButtonEntry(507, I18n.func_135052_a((String)"createWorld.customize.custom.useFossils", (Object[])new Object[0]), true, this.settings.useFossils), new GuiPageButtonList.GuiLabelEntry(511, I18n.func_135052_a((String)"createWorld.customize.custom.otherLabel", (Object[])new Object[0]), true), null, new GuiPageButtonList.GuiSlideEntry(160, I18n.func_135052_a((String)"createWorld.customize.custom.seaLevel", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.seaLevel), new GuiPageButtonList.GuiButtonEntry(148, I18n.func_135052_a((String)"createWorld.customize.custom.useCaves", (Object[])new Object[0]), true, this.settings.useCaves), new GuiPageButtonList.GuiButtonEntry(150, I18n.func_135052_a((String)"createWorld.customize.custom.useStrongholds", (Object[])new Object[0]), true, this.settings.useStrongholds), new GuiPageButtonList.GuiButtonEntry(151, I18n.func_135052_a((String)"createWorld.customize.custom.useVillages", (Object[])new Object[0]), true, this.settings.useVillages), new GuiPageButtonList.GuiButtonEntry(152, I18n.func_135052_a((String)"createWorld.customize.custom.useMineShafts", (Object[])new Object[0]), true, this.settings.useMineShafts), new GuiPageButtonList.GuiButtonEntry(153, I18n.func_135052_a((String)"createWorld.customize.custom.useTemples", (Object[])new Object[0]), true, this.settings.useTemples), new GuiPageButtonList.GuiButtonEntry(210, I18n.func_135052_a((String)"createWorld.customize.custom.useMonuments", (Object[])new Object[0]), true, this.settings.useMonuments), new GuiPageButtonList.GuiButtonEntry(211, I18n.func_135052_a((String)"createWorld.customize.custom.useMansions", (Object[])new Object[0]), true, this.settings.useMansions), new GuiPageButtonList.GuiButtonEntry(154, I18n.func_135052_a((String)"createWorld.customize.custom.useRavines", (Object[])new Object[0]), true, this.settings.useRavines), new GuiPageButtonList.GuiButtonEntry(149, I18n.func_135052_a((String)"createWorld.customize.custom.useDungeons", (Object[])new Object[0]), true, this.settings.useDungeons), new GuiPageButtonList.GuiSlideEntry(157, I18n.func_135052_a((String)"createWorld.customize.custom.dungeonChance", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 1.0f, 100.0f, (float)this.settings.dungeonChance), new GuiPageButtonList.GuiButtonEntry(155, I18n.func_135052_a((String)"createWorld.customize.custom.useWaterLakes", (Object[])new Object[0]), true, this.settings.useWaterLakes), new GuiPageButtonList.GuiSlideEntry(158, I18n.func_135052_a((String)"createWorld.customize.custom.waterLakeChance", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 1.0f, 100.0f, (float)this.settings.waterLakeChance), new GuiPageButtonList.GuiButtonEntry(156, I18n.func_135052_a((String)"createWorld.customize.custom.useLavaLakes", (Object[])new Object[0]), true, this.settings.useLavaLakes), new GuiPageButtonList.GuiSlideEntry(159, I18n.func_135052_a((String)"createWorld.customize.custom.lavaLakeChance", (Object[])new Object[0]), true, (GuiSlider.FormatHelper)this, 10.0f, 100.0f, (float)this.settings.lavaLakeChance), new GuiPageButtonList.GuiButtonEntry(161, I18n.func_135052_a((String)"createWorld.customize.custom.useLavaOceans", (Object[])new Object[0]), true, this.settings.useLavaOceans)};
        GuiPageButtonList.GuiListEntry[] pageList1 = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiLabelEntry(600, I18n.func_135052_a((String)"tile.clay.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(601, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.claySize), new GuiPageButtonList.GuiSlideEntry(602, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.clayCount), new GuiPageButtonList.GuiSlideEntry(603, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.clayMinHeight), new GuiPageButtonList.GuiSlideEntry(604, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.clayMaxHeight), new GuiPageButtonList.GuiLabelEntry(416, I18n.func_135052_a((String)"tile.dirt.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(165, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.dirtSize), new GuiPageButtonList.GuiSlideEntry(166, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.dirtCount), new GuiPageButtonList.GuiSlideEntry(167, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.dirtMinHeight), new GuiPageButtonList.GuiSlideEntry(168, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.dirtMaxHeight), new GuiPageButtonList.GuiLabelEntry(417, I18n.func_135052_a((String)"tile.gravel.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(169, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.gravelSize), new GuiPageButtonList.GuiSlideEntry(170, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.gravelCount), new GuiPageButtonList.GuiSlideEntry(171, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.gravelMinHeight), new GuiPageButtonList.GuiSlideEntry(172, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.gravelMaxHeight), new GuiPageButtonList.GuiLabelEntry(418, I18n.func_135052_a((String)"tile.stone.granite.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(173, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.graniteSize), new GuiPageButtonList.GuiSlideEntry(174, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.graniteCount), new GuiPageButtonList.GuiSlideEntry(175, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.graniteMinHeight), new GuiPageButtonList.GuiSlideEntry(176, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.graniteMaxHeight), new GuiPageButtonList.GuiLabelEntry(419, I18n.func_135052_a((String)"tile.stone.diorite.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(177, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.dioriteSize), new GuiPageButtonList.GuiSlideEntry(178, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.dioriteCount), new GuiPageButtonList.GuiSlideEntry(179, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.dioriteMinHeight), new GuiPageButtonList.GuiSlideEntry(180, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.dioriteMaxHeight), new GuiPageButtonList.GuiLabelEntry(420, I18n.func_135052_a((String)"tile.stone.andesite.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(181, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.andesiteSize), new GuiPageButtonList.GuiSlideEntry(182, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.andesiteCount), new GuiPageButtonList.GuiSlideEntry(183, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.andesiteMinHeight), new GuiPageButtonList.GuiSlideEntry(184, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.andesiteMaxHeight), new GuiPageButtonList.GuiLabelEntry(421, I18n.func_135052_a((String)"tile.oreCoal.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(185, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.coalSize), new GuiPageButtonList.GuiSlideEntry(186, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.coalCount), new GuiPageButtonList.GuiSlideEntry(187, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.coalMinHeight), new GuiPageButtonList.GuiSlideEntry(189, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.coalMaxHeight), new GuiPageButtonList.GuiLabelEntry(422, I18n.func_135052_a((String)"tile.oreIron.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(190, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.ironSize), new GuiPageButtonList.GuiSlideEntry(191, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.ironCount), new GuiPageButtonList.GuiSlideEntry(192, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.ironMinHeight), new GuiPageButtonList.GuiSlideEntry(193, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.ironMaxHeight), new GuiPageButtonList.GuiLabelEntry(423, I18n.func_135052_a((String)"tile.oreGold.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(194, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.goldSize), new GuiPageButtonList.GuiSlideEntry(195, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.goldCount), new GuiPageButtonList.GuiSlideEntry(196, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.goldMinHeight), new GuiPageButtonList.GuiSlideEntry(197, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.goldMaxHeight), new GuiPageButtonList.GuiLabelEntry(424, I18n.func_135052_a((String)"tile.oreRedstone.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(198, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.redstoneSize), new GuiPageButtonList.GuiSlideEntry(199, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.redstoneCount), new GuiPageButtonList.GuiSlideEntry(200, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.redstoneMinHeight), new GuiPageButtonList.GuiSlideEntry(201, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.redstoneMaxHeight), new GuiPageButtonList.GuiLabelEntry(425, I18n.func_135052_a((String)"tile.oreDiamond.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(202, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.diamondSize), new GuiPageButtonList.GuiSlideEntry(203, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.diamondCount), new GuiPageButtonList.GuiSlideEntry(204, I18n.func_135052_a((String)"createWorld.customize.custom.minHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.diamondMinHeight), new GuiPageButtonList.GuiSlideEntry(205, I18n.func_135052_a((String)"createWorld.customize.custom.maxHeight", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.diamondMaxHeight), new GuiPageButtonList.GuiLabelEntry(426, I18n.func_135052_a((String)"tile.oreLapis.name", (Object[])new Object[0]), false), null, new GuiPageButtonList.GuiSlideEntry(206, I18n.func_135052_a((String)"createWorld.customize.custom.size", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 50.0f, (float)this.settings.lapisSize), new GuiPageButtonList.GuiSlideEntry(207, I18n.func_135052_a((String)"createWorld.customize.custom.count", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 40.0f, (float)this.settings.lapisCount), new GuiPageButtonList.GuiSlideEntry(208, I18n.func_135052_a((String)"createWorld.customize.custom.center", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.lapisCenterHeight), new GuiPageButtonList.GuiSlideEntry(209, I18n.func_135052_a((String)"createWorld.customize.custom.spread", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.0f, 255.0f, (float)this.settings.lapisSpread)};
        GuiPageButtonList.GuiListEntry[] pageList2 = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiSlideEntry(100, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleX", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 5000.0f, this.settings.mainNoiseScaleX), new GuiPageButtonList.GuiSlideEntry(101, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleY", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 5000.0f, this.settings.mainNoiseScaleY), new GuiPageButtonList.GuiSlideEntry(102, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleZ", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 5000.0f, this.settings.mainNoiseScaleZ), new GuiPageButtonList.GuiSlideEntry(103, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleX", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 2000.0f, this.settings.depthNoiseScaleX), new GuiPageButtonList.GuiSlideEntry(104, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleZ", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 2000.0f, this.settings.depthNoiseScaleZ), new GuiPageButtonList.GuiSlideEntry(105, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleExponent", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.01f, 20.0f, this.settings.depthNoiseScaleExponent), new GuiPageButtonList.GuiSlideEntry(106, I18n.func_135052_a((String)"createWorld.customize.custom.baseSize", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 25.0f, this.settings.baseSize), new GuiPageButtonList.GuiSlideEntry(107, I18n.func_135052_a((String)"createWorld.customize.custom.coordinateScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 6000.0f, this.settings.coordinateScale), new GuiPageButtonList.GuiSlideEntry(108, I18n.func_135052_a((String)"createWorld.customize.custom.heightScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 6000.0f, this.settings.heightScale), new GuiPageButtonList.GuiSlideEntry(109, I18n.func_135052_a((String)"createWorld.customize.custom.stretchY", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.01f, 50.0f, this.settings.stretchY), new GuiPageButtonList.GuiSlideEntry(110, I18n.func_135052_a((String)"createWorld.customize.custom.upperLimitScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 5000.0f, this.settings.upperLimitScale), new GuiPageButtonList.GuiSlideEntry(111, I18n.func_135052_a((String)"createWorld.customize.custom.lowerLimitScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 5000.0f, this.settings.lowerLimitScale), new GuiPageButtonList.GuiSlideEntry(113, I18n.func_135052_a((String)"createWorld.customize.custom.tempNoiseScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.1f, 8.0f, this.settings.tempNoiseScale), new GuiPageButtonList.GuiSlideEntry(114, I18n.func_135052_a((String)"createWorld.customize.custom.rainNoiseScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.1f, 8.0f, this.settings.rainNoiseScale), new GuiPageButtonList.GuiSlideEntry(115, I18n.func_135052_a((String)"createWorld.customize.custom.detailNoiseScale", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 0.1f, 8.0f, this.settings.detailNoiseScale), new GuiPageButtonList.GuiSlideEntry(112, I18n.func_135052_a((String)"createWorld.customize.custom.height", (Object[])new Object[0]), false, (GuiSlider.FormatHelper)this, 1.0f, 255.0f, (float)this.settings.height)};
        GuiPageButtonList.GuiListEntry[] pageList3 = new GuiPageButtonList.GuiListEntry[]{new GuiPageButtonList.GuiLabelEntry(400, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleX", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(132, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleX)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(401, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleY", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(133, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleY)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(402, I18n.func_135052_a((String)"createWorld.customize.custom.mainNoiseScaleZ", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(134, String.format("%5.3f", Float.valueOf(this.settings.mainNoiseScaleZ)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(403, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleX", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(135, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleX)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(404, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleZ", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(136, String.format("%5.3f", Float.valueOf(this.settings.depthNoiseScaleZ)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(405, I18n.func_135052_a((String)"createWorld.customize.custom.depthNoiseScaleExponent", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(137, String.format("%2.3f", Float.valueOf(this.settings.depthNoiseScaleExponent)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(406, I18n.func_135052_a((String)"createWorld.customize.custom.baseSize", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(138, String.format("%2.3f", Float.valueOf(this.settings.baseSize)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(407, I18n.func_135052_a((String)"createWorld.customize.custom.coordinateScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(139, String.format("%5.3f", Float.valueOf(this.settings.coordinateScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(408, I18n.func_135052_a((String)"createWorld.customize.custom.heightScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(140, String.format("%5.3f", Float.valueOf(this.settings.heightScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(409, I18n.func_135052_a((String)"createWorld.customize.custom.stretchY", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(141, String.format("%2.3f", Float.valueOf(this.settings.stretchY)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(410, I18n.func_135052_a((String)"createWorld.customize.custom.upperLimitScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(142, String.format("%5.3f", Float.valueOf(this.settings.upperLimitScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(411, I18n.func_135052_a((String)"createWorld.customize.custom.lowerLimitScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(143, String.format("%5.3f", Float.valueOf(this.settings.lowerLimitScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(413, I18n.func_135052_a((String)"createWorld.customize.custom.tempNoiseScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(145, String.format("%2.3f", Float.valueOf(this.settings.tempNoiseScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(414, I18n.func_135052_a((String)"createWorld.customize.custom.rainNoiseScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(146, String.format("%2.3f", Float.valueOf(this.settings.rainNoiseScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(415, I18n.func_135052_a((String)"createWorld.customize.custom.detailNoiseScale", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(147, String.format("%2.3f", Float.valueOf(this.settings.detailNoiseScale)), false, this.floatFilter), new GuiPageButtonList.GuiLabelEntry(412, I18n.func_135052_a((String)"createWorld.customize.custom.height", (Object[])new Object[0]) + ":", false), new GuiPageButtonList.EditBoxEntry(144, String.format("%d", this.settings.height), false, this.intFilter)};
        this.pageList = new GuiPageButtonList(this.field_146297_k, this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 32, 25, (GuiPageButtonList.GuiResponder)this, (GuiPageButtonList.GuiListEntry[][])new GuiPageButtonList.GuiListEntry[][]{pageList0, pageList1, pageList2, pageList3});
        for (int page = 0; page < 4; ++page) {
            this.pageNames[page] = I18n.func_135052_a((String)("createWorld.customize.custom.page" + page), (Object[])new Object[0]);
        }
        this.updatePageControls();
    }

    public void func_73866_w_() {
        int curPage = 0;
        int curScroll = 0;
        if (this.pageList != null) {
            curPage = this.pageList.func_178059_e();
            curScroll = this.pageList.func_148148_g();
        }
        this.title = I18n.func_135052_a((String)"options.customizeTitle", (Object[])new Object[0]);
        this.field_146292_n.clear();
        this.previousPage = this.func_189646_b(new GuiButton(302, 20, 5, 80, 20, I18n.func_135052_a((String)"createWorld.customize.custom.prev", (Object[])new Object[0])));
        this.nextPage = this.func_189646_b(new GuiButton(303, this.field_146294_l - 100, 5, 80, 20, I18n.func_135052_a((String)"createWorld.customize.custom.next", (Object[])new Object[0])));
        this.defaults = this.func_189646_b(new GuiButton(304, this.field_146294_l / 2 - 187, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"createWorld.customize.custom.defaults", (Object[])new Object[0])));
        this.randomize = this.func_189646_b(new GuiButton(301, this.field_146294_l / 2 - 92, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"createWorld.customize.custom.randomize", (Object[])new Object[0])));
        this.presets = this.func_189646_b(new GuiButton(305, this.field_146294_l / 2 + 3, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"createWorld.customize.custom.presets", (Object[])new Object[0])));
        this.done = this.func_189646_b(new GuiButton(300, this.field_146294_l / 2 + 98, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.defaults.field_146124_l = this.settingsModified;
        this.confirm = new GuiButton(306, this.field_146294_l / 2 - 55, 160, 50, 20, I18n.func_135052_a((String)"gui.yes", (Object[])new Object[0]));
        this.confirm.field_146125_m = false;
        this.cancel = new GuiButton(307, this.field_146294_l / 2 + 5, 160, 50, 20, I18n.func_135052_a((String)"gui.no", (Object[])new Object[0]));
        this.cancel.field_146125_m = false;
        this.field_146292_n.add(this.confirm);
        this.field_146292_n.add(this.cancel);
        if (this.confirmMode != 0) {
            this.confirm.field_146125_m = true;
            this.cancel.field_146125_m = true;
        }
        this.createPagedList();
        if (curPage != 0) {
            this.pageList.func_181156_c(curPage);
            this.pageList.func_148145_f(curScroll);
            this.updatePageControls();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.pageList.func_178039_p();
    }

    public String func_175318_a(int entry, String entryString, float entryValue) {
        return entryString + ": " + this.getFormattedValue(entry, entryValue);
    }

    public void func_175319_a(int entry, String string) {
        if (entry == 801) {
            this.settings.fixedBiome = string;
        } else {
            float entryValue = 0.0f;
            try {
                entryValue = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            float newEntryValue = 0.0f;
            switch (entry) {
                case 139: {
                    newEntryValue = this.settings.coordinateScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)6000.0f);
                    break;
                }
                case 140: {
                    newEntryValue = this.settings.heightScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)6000.0f);
                    break;
                }
                case 142: {
                    newEntryValue = this.settings.upperLimitScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 143: {
                    newEntryValue = this.settings.lowerLimitScale = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 144: {
                    this.settings.height = (int)MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)255.0f);
                    newEntryValue = this.settings.height;
                    break;
                }
                case 145: {
                    newEntryValue = this.settings.tempNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 146: {
                    newEntryValue = this.settings.rainNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 147: {
                    newEntryValue = this.settings.detailNoiseScale = MathHelper.func_76131_a((float)entryValue, (float)0.1f, (float)8.0f);
                    break;
                }
                case 135: {
                    newEntryValue = this.settings.depthNoiseScaleX = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)2000.0f);
                    break;
                }
                case 136: {
                    newEntryValue = this.settings.depthNoiseScaleZ = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)2000.0f);
                    break;
                }
                case 137: {
                    newEntryValue = this.settings.depthNoiseScaleExponent = MathHelper.func_76131_a((float)entryValue, (float)0.01f, (float)20.0f);
                    break;
                }
                case 132: {
                    newEntryValue = this.settings.mainNoiseScaleX = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 133: {
                    newEntryValue = this.settings.mainNoiseScaleY = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 134: {
                    newEntryValue = this.settings.mainNoiseScaleZ = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)5000.0f);
                    break;
                }
                case 138: {
                    newEntryValue = this.settings.baseSize = MathHelper.func_76131_a((float)entryValue, (float)1.0f, (float)25.0f);
                    break;
                }
                case 141: {
                    newEntryValue = this.settings.stretchY = MathHelper.func_76131_a((float)entryValue, (float)0.01f, (float)50.0f);
                }
            }
            if (newEntryValue != entryValue && entryValue != 0.0f) {
                ((GuiTextField)this.pageList.func_178061_c(entry)).func_146180_a(this.getFormattedValue(entry, newEntryValue));
            }
            ((GuiSlider)this.pageList.func_178061_c(entry - 132 + 100)).func_175218_a(newEntryValue, false);
        }
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    public void func_175321_a(int integer, boolean entryValue) {
        switch (integer) {
            case 148: {
                this.settings.useCaves = entryValue;
                break;
            }
            case 149: {
                this.settings.useDungeons = entryValue;
                break;
            }
            case 150: {
                this.settings.useStrongholds = entryValue;
                break;
            }
            case 151: {
                this.settings.useVillages = entryValue;
                break;
            }
            case 152: {
                this.settings.useMineShafts = entryValue;
                break;
            }
            case 153: {
                this.settings.useTemples = entryValue;
                break;
            }
            case 154: {
                this.settings.useRavines = entryValue;
                break;
            }
            case 210: {
                this.settings.useMonuments = entryValue;
                break;
            }
            case 211: {
                this.settings.useMansions = entryValue;
                break;
            }
            case 155: {
                this.settings.useWaterLakes = entryValue;
                break;
            }
            case 156: {
                this.settings.useLavaLakes = entryValue;
                break;
            }
            case 161: {
                this.settings.useLavaOceans = entryValue;
                break;
            }
            case 500: {
                this.settings.replaceOceanBiomes = entryValue;
                break;
            }
            case 501: {
                this.settings.replaceBeachBiomes = entryValue;
                break;
            }
            case 502: {
                this.settings.useTallGrass = entryValue;
                break;
            }
            case 503: {
                this.settings.useNewFlowers = entryValue;
                break;
            }
            case 504: {
                this.settings.useLilyPads = entryValue;
                break;
            }
            case 505: {
                this.settings.useMelons = entryValue;
                break;
            }
            case 506: {
                this.settings.useDesertWells = entryValue;
                break;
            }
            case 507: {
                this.settings.useFossils = entryValue;
            }
        }
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    public void func_175320_a(int entry, float entryValue) {
        Gui gui;
        switch (entry) {
            case 107: {
                this.settings.coordinateScale = entryValue;
                break;
            }
            case 108: {
                this.settings.heightScale = entryValue;
                break;
            }
            case 110: {
                this.settings.upperLimitScale = entryValue;
                break;
            }
            case 111: {
                this.settings.lowerLimitScale = entryValue;
                break;
            }
            case 112: {
                this.settings.height = (int)entryValue;
                break;
            }
            case 113: {
                this.settings.tempNoiseScale = entryValue;
                break;
            }
            case 114: {
                this.settings.rainNoiseScale = entryValue;
                break;
            }
            case 115: {
                this.settings.detailNoiseScale = entryValue;
                break;
            }
            case 103: {
                this.settings.depthNoiseScaleX = entryValue;
                break;
            }
            case 104: {
                this.settings.depthNoiseScaleZ = entryValue;
                break;
            }
            case 105: {
                this.settings.depthNoiseScaleExponent = entryValue;
                break;
            }
            case 100: {
                this.settings.mainNoiseScaleX = entryValue;
                break;
            }
            case 101: {
                this.settings.mainNoiseScaleY = entryValue;
                break;
            }
            case 102: {
                this.settings.mainNoiseScaleZ = entryValue;
                break;
            }
            case 106: {
                this.settings.baseSize = entryValue;
                break;
            }
            case 109: {
                this.settings.stretchY = entryValue;
                break;
            }
            case 157: {
                this.settings.dungeonChance = (int)entryValue;
                break;
            }
            case 158: {
                this.settings.waterLakeChance = (int)entryValue;
                break;
            }
            case 159: {
                this.settings.lavaLakeChance = (int)entryValue;
                break;
            }
            case 160: {
                this.settings.seaLevel = (int)entryValue;
                break;
            }
            case 162: {
                this.settings.fixedBiome = ((Biome)ForgeRegistries.BIOMES.getValues().get((int)entryValue)).getRegistryName().toString();
                break;
            }
            case 166: {
                this.settings.dirtCount = (int)entryValue;
                break;
            }
            case 165: {
                this.settings.dirtSize = (int)entryValue;
                break;
            }
            case 167: {
                this.settings.dirtMinHeight = (int)entryValue;
                break;
            }
            case 168: {
                this.settings.dirtMaxHeight = (int)entryValue;
                break;
            }
            case 170: {
                this.settings.gravelCount = (int)entryValue;
                break;
            }
            case 169: {
                this.settings.gravelSize = (int)entryValue;
                break;
            }
            case 171: {
                this.settings.gravelMinHeight = (int)entryValue;
                break;
            }
            case 172: {
                this.settings.gravelMaxHeight = (int)entryValue;
                break;
            }
            case 174: {
                this.settings.graniteCount = (int)entryValue;
                break;
            }
            case 173: {
                this.settings.graniteSize = (int)entryValue;
                break;
            }
            case 175: {
                this.settings.graniteMinHeight = (int)entryValue;
                break;
            }
            case 176: {
                this.settings.graniteMaxHeight = (int)entryValue;
                break;
            }
            case 178: {
                this.settings.dioriteCount = (int)entryValue;
                break;
            }
            case 177: {
                this.settings.dioriteSize = (int)entryValue;
                break;
            }
            case 179: {
                this.settings.dioriteMinHeight = (int)entryValue;
                break;
            }
            case 180: {
                this.settings.dioriteMaxHeight = (int)entryValue;
                break;
            }
            case 182: {
                this.settings.andesiteCount = (int)entryValue;
                break;
            }
            case 181: {
                this.settings.andesiteSize = (int)entryValue;
                break;
            }
            case 183: {
                this.settings.andesiteMinHeight = (int)entryValue;
                break;
            }
            case 184: {
                this.settings.andesiteMaxHeight = (int)entryValue;
                break;
            }
            case 186: {
                this.settings.coalCount = (int)entryValue;
                break;
            }
            case 185: {
                this.settings.coalSize = (int)entryValue;
                break;
            }
            case 187: {
                this.settings.coalMinHeight = (int)entryValue;
                break;
            }
            case 189: {
                this.settings.coalMaxHeight = (int)entryValue;
                break;
            }
            case 191: {
                this.settings.ironCount = (int)entryValue;
                break;
            }
            case 190: {
                this.settings.ironSize = (int)entryValue;
                break;
            }
            case 192: {
                this.settings.ironMinHeight = (int)entryValue;
                break;
            }
            case 193: {
                this.settings.ironMaxHeight = (int)entryValue;
                break;
            }
            case 195: {
                this.settings.goldCount = (int)entryValue;
                break;
            }
            case 194: {
                this.settings.goldSize = (int)entryValue;
                break;
            }
            case 196: {
                this.settings.goldMinHeight = (int)entryValue;
                break;
            }
            case 197: {
                this.settings.goldMaxHeight = (int)entryValue;
                break;
            }
            case 199: {
                this.settings.redstoneCount = (int)entryValue;
                break;
            }
            case 198: {
                this.settings.redstoneSize = (int)entryValue;
                break;
            }
            case 200: {
                this.settings.redstoneMinHeight = (int)entryValue;
                break;
            }
            case 201: {
                this.settings.redstoneMaxHeight = (int)entryValue;
                break;
            }
            case 203: {
                this.settings.diamondCount = (int)entryValue;
                break;
            }
            case 202: {
                this.settings.diamondSize = (int)entryValue;
                break;
            }
            case 204: {
                this.settings.diamondMinHeight = (int)entryValue;
                break;
            }
            case 205: {
                this.settings.diamondMaxHeight = (int)entryValue;
                break;
            }
            case 207: {
                this.settings.lapisCount = (int)entryValue;
                break;
            }
            case 206: {
                this.settings.lapisSize = (int)entryValue;
                break;
            }
            case 208: {
                this.settings.lapisCenterHeight = (int)entryValue;
                break;
            }
            case 209: {
                this.settings.lapisSpread = (int)entryValue;
                break;
            }
            case 602: {
                this.settings.clayCount = (int)entryValue;
                break;
            }
            case 601: {
                this.settings.claySize = (int)entryValue;
                break;
            }
            case 603: {
                this.settings.clayMinHeight = (int)entryValue;
                break;
            }
            case 604: {
                this.settings.clayMaxHeight = (int)entryValue;
                break;
            }
            case 700: {
                this.settings.chunkSource = ChunkSourceType.values()[(int)entryValue].getId();
                break;
            }
            case 701: {
                this.settings.biomeSource = BiomeSourceType.values()[(int)entryValue].getId();
            }
        }
        if (entry >= 100 && entry < 116 && (gui = this.pageList.func_178061_c(entry - 100 + 132)) != null) {
            ((GuiTextField)gui).func_146180_a(this.getFormattedValue(entry, entryValue));
        }
        if (!this.settings.equals(this.defaultSettings)) {
            this.setSettingsModified(true);
        }
    }

    public String saveValues() {
        return this.settings.toString().replace("\n", "");
    }

    public void loadValues(String string) {
        this.settings = string != null && !string.isEmpty() ? ModernBetaChunkGeneratorSettings.Factory.jsonToFactory(string) : new ModernBetaChunkGeneratorSettings.Factory();
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (!guiButton.field_146124_l) {
            return;
        }
        switch (guiButton.field_146127_k) {
            case 300: {
                this.parent.field_146334_a = this.settings.toString();
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 305: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenCustomizePresets(this));
                break;
            }
            case 301: {
                for (int page = 0; page < this.pageList.func_148127_b(); ++page) {
                    float randomFloat;
                    GuiButton guiButtonComponent;
                    GuiPageButtonList.GuiEntry guiEntry = this.pageList.func_148180_b(page);
                    Gui guiComponent = guiEntry.func_178022_a();
                    if (guiComponent instanceof GuiButton) {
                        guiButtonComponent = (GuiButton)guiComponent;
                        if (guiButtonComponent instanceof GuiSlider) {
                            randomFloat = ((GuiSlider)guiButtonComponent).func_175217_d() * (0.75f + this.random.nextFloat() * 0.5f) + (this.random.nextFloat() * 0.1f - 0.05f);
                            ((GuiSlider)guiButtonComponent).func_175219_a(MathHelper.func_76131_a((float)randomFloat, (float)0.0f, (float)1.0f));
                        } else if (guiButtonComponent instanceof GuiListButton) {
                            ((GuiListButton)guiButtonComponent).func_175212_b(this.random.nextBoolean());
                        }
                    }
                    if (!((guiComponent = guiEntry.func_178021_b()) instanceof GuiButton)) continue;
                    guiButtonComponent = (GuiButton)guiComponent;
                    if (guiButtonComponent instanceof GuiSlider) {
                        randomFloat = ((GuiSlider)guiButtonComponent).func_175217_d() * (0.75f + this.random.nextFloat() * 0.5f) + (this.random.nextFloat() * 0.1f - 0.05f);
                        ((GuiSlider)guiButtonComponent).func_175219_a(MathHelper.func_76131_a((float)randomFloat, (float)0.0f, (float)1.0f));
                        continue;
                    }
                    if (!(guiButtonComponent instanceof GuiListButton)) continue;
                    ((GuiListButton)guiButtonComponent).func_175212_b(this.random.nextBoolean());
                }
                break;
            }
            case 302: {
                this.pageList.func_178071_h();
                this.updatePageControls();
                break;
            }
            case 303: {
                this.pageList.func_178064_i();
                this.updatePageControls();
                break;
            }
            case 304: {
                if (!this.settingsModified) break;
                this.enterConfirmation(304);
                break;
            }
            case 307: {
                this.confirmMode = 0;
                this.exitConfirmation();
                break;
            }
            case 306: {
                this.exitConfirmation();
            }
        }
    }

    protected void func_73869_a(char character, int integer) throws IOException {
        super.func_73869_a(character, integer);
        if (this.confirmMode != 0) {
            return;
        }
        switch (integer) {
            case 208: {
                this.modifyFocusValue(-1.0f);
                break;
            }
            case 200: {
                this.modifyFocusValue(1.0f);
                break;
            }
            default: {
                this.pageList.func_178062_a(character, integer);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int clicked) throws IOException {
        super.func_73864_a(mouseX, mouseY, clicked);
        if (this.confirmMode != 0 || this.confirmDismissed) {
            return;
        }
        this.pageList.func_148179_a(mouseX, mouseY, clicked);
    }

    protected void func_146286_b(int integer2, int integer3, int integer4) {
        super.func_146286_b(integer2, integer3, integer4);
        if (this.confirmDismissed) {
            this.confirmDismissed = false;
            return;
        }
        if (this.confirmMode != 0) {
            return;
        }
        this.pageList.func_148181_b(integer2, integer3, integer4);
    }

    private String getFormattedValue(int entry, float entryValue) {
        switch (entry) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 139: 
            case 140: 
            case 142: 
            case 143: {
                return String.format("%5.3f", Float.valueOf(entryValue));
            }
            case 105: 
            case 106: 
            case 109: 
            case 113: 
            case 114: 
            case 115: 
            case 137: 
            case 138: 
            case 141: 
            case 145: 
            case 146: 
            case 147: {
                return String.format("%2.3f", Float.valueOf(entryValue));
            }
            case 162: {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValues().get((int)entryValue);
                return biome != null ? biome.func_185359_l() : "?";
            }
            case 700: {
                return ChunkSourceType.values()[(int)entryValue].getName();
            }
            case 701: {
                return BiomeSourceType.values()[(int)entryValue].getName();
            }
        }
        return String.format("%d", (int)entryValue);
    }

    private void setSettingsModified(boolean settingsModified) {
        this.settingsModified = settingsModified;
        this.defaults.field_146124_l = settingsModified;
    }

    private void restoreDefaults() {
        this.settings.setDefaults();
        this.createPagedList();
        this.setSettingsModified(false);
    }

    private void enterConfirmation(int integer) {
        this.confirmMode = integer;
        this.setConfirmationControls(true);
    }

    private void exitConfirmation() throws IOException {
        switch (this.confirmMode) {
            case 300: {
                this.func_146284_a((GuiButton)this.pageList.func_178061_c(300));
                break;
            }
            case 304: {
                this.restoreDefaults();
            }
        }
        this.confirmMode = 0;
        this.confirmDismissed = true;
        this.setConfirmationControls(false);
    }

    private void setConfirmationControls(boolean setConfirm) {
        this.confirm.field_146125_m = setConfirm;
        this.cancel.field_146125_m = setConfirm;
        this.randomize.field_146124_l = !setConfirm;
        this.done.field_146124_l = !setConfirm;
        this.previousPage.field_146124_l = !setConfirm;
        this.nextPage.field_146124_l = !setConfirm;
        this.defaults.field_146124_l = this.settingsModified && !setConfirm;
        this.presets.field_146124_l = !setConfirm;
        this.pageList.func_181155_a(!setConfirm);
    }

    private void updatePageControls() {
        this.previousPage.field_146124_l = this.pageList.func_178059_e() != 0;
        this.nextPage.field_146124_l = this.pageList.func_178059_e() != this.pageList.func_178057_f() - 1;
        this.subtitle = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.pageList.func_178059_e() + 1, this.pageList.func_178057_f()});
        this.pageTitle = this.pageNames[this.pageList.func_178059_e()];
        this.randomize.field_146124_l = this.pageList.func_178059_e() != this.pageList.func_178057_f() - 1;
    }

    private void modifyFocusValue(float float2) {
        GuiTextField guiTextField5;
        Float float6;
        Gui gui3 = this.pageList.func_178056_g();
        if (!(gui3 instanceof GuiTextField)) {
            return;
        }
        float float4 = float2;
        if (GuiScreen.func_146272_n()) {
            float4 *= 0.1f;
            if (GuiScreen.func_146271_m()) {
                float4 *= 0.1f;
            }
        } else if (GuiScreen.func_146271_m()) {
            float4 *= 10.0f;
            if (GuiScreen.func_175283_s()) {
                float4 *= 10.0f;
            }
        }
        if ((float6 = Floats.tryParse((String)(guiTextField5 = (GuiTextField)gui3).func_146179_b())) == null) {
            return;
        }
        float6 = Float.valueOf(float6.floatValue() + float4);
        int integer7 = guiTextField5.func_175206_d();
        String string8 = this.getFormattedValue(guiTextField5.func_175206_d(), float6.floatValue());
        guiTextField5.func_146180_a(string8);
        this.func_175319_a(integer7, string8);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.pageList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 2, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.subtitle, this.field_146294_l / 2, 12, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.pageTitle, this.field_146294_l / 2, 22, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.confirmMode != 0) {
            Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 99, -2039584);
            this.func_73730_a(this.field_146294_l / 2 - 91, this.field_146294_l / 2 + 90, 185, -6250336);
            this.func_73728_b(this.field_146294_l / 2 - 91, 99, 185, -2039584);
            this.func_73728_b(this.field_146294_l / 2 + 90, 99, 185, -6250336);
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 - 90), 185.0, 0.0).func_187315_a(0.0, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 + 90), 185.0, 0.0).func_187315_a(5.625, 2.65625).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 + 90), 100.0, 0.0).func_187315_a(5.625, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            bufferBuilder.func_181662_b((double)(this.field_146294_l / 2 - 90), 100.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(64, 64, 64, 64).func_181675_d();
            tessellator.func_78381_a();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirmTitle", (Object[])new Object[0]), this.field_146294_l / 2, 105, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirm1", (Object[])new Object[0]), this.field_146294_l / 2, 125, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.custom.confirm2", (Object[])new Object[0]), this.field_146294_l / 2, 135, 0xFFFFFF);
            this.confirm.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            this.cancel.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }
}

