/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.color;

import java.util.Optional;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.Clime;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.SkyClimateSampler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;

public class BetaColorSampler {
    public static final BetaColorSampler INSTANCE = new BetaColorSampler();
    private Optional<ClimateSampler> climateSampler = Optional.empty();
    private Optional<SkyClimateSampler> skyClimateSampler = Optional.empty();

    private BetaColorSampler() {
    }

    public void resetClimateSamplers() {
        this.climateSampler = Optional.empty();
        this.skyClimateSampler = Optional.empty();
    }

    public void setClimateSamplers(ClimateSampler climateSampler, SkyClimateSampler skyClimateSampler) {
        this.climateSampler = Optional.ofNullable(climateSampler);
        this.skyClimateSampler = Optional.ofNullable(skyClimateSampler);
    }

    public int getSkyColor(BlockPos blockPos) {
        float temp = (float)this.skyClimateSampler.get().sampleSkyTemp(blockPos.func_177958_n(), blockPos.func_177952_p());
        temp /= 3.0f;
        temp = MathHelper.func_76131_a((float)temp, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.6222222f - temp * 0.05f), (float)(0.5f + temp * 0.1f), (float)1.0f);
    }

    public int getGrassColor(BlockPos blockPos) {
        Clime clime = this.climateSampler.get().sample(blockPos.func_177958_n(), blockPos.func_177952_p());
        return ColorizerGrass.func_77480_a((double)clime.temp(), (double)clime.rain());
    }

    public int getFoliageColor(BlockPos blockPos) {
        Clime clime = this.climateSampler.get().sample(blockPos.func_177958_n(), blockPos.func_177952_p());
        return ColorizerFoliage.func_77470_a((double)clime.temp(), (double)clime.rain());
    }

    public int getTallGrassColor(BlockPos blockPos) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        long shift = x * 3129871 + z * 6129781 + y;
        shift = shift * shift * 42317861L + shift * 11L;
        x = (int)((long)x + (shift >> 14 & 0x1FL));
        y = (int)((long)y + (shift >> 19 & 0x1FL));
        z = (int)((long)z + (shift >> 24 & 0x1FL));
        Clime clime = this.climateSampler.get().sample(x, z);
        return ColorizerGrass.func_77480_a((double)clime.temp(), (double)clime.rain());
    }

    public boolean canSampleSkyColor() {
        return this.skyClimateSampler.isPresent() && this.skyClimateSampler.get().sampleSkyColor();
    }

    public boolean canSampleBiomeColor() {
        return this.climateSampler.isPresent() && this.climateSampler.get().sampleBiomeColor();
    }
}

