/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.gen.noise.NoiseSource;
import mod.bespectacled.modernbetaforge.util.BlockStates;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.ChunkCache;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaNoiseSettings;
import mod.bespectacled.modernbetaforge.world.gen.blocksource.BlockSource;
import mod.bespectacled.modernbetaforge.world.gen.blocksource.BlockSourceRules;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class NoiseChunkSource
extends ChunkSource {
    protected final IBlockState defaultBlock = BlockStates.STONE;
    protected final IBlockState defaultFluid;
    protected final int worldMinY;
    protected final int worldHeight;
    protected final int worldTopY;
    protected final int seaLevel;
    protected final int bedrockFloor;
    protected final int bedrockCeiling;
    protected final int verticalNoiseResolution;
    protected final int horizontalNoiseResolution;
    protected final int noiseSizeX;
    protected final int noiseSizeZ;
    protected final int noiseSizeY;
    protected final int noiseTopY;
    protected final ModernBetaNoiseSettings.SlideSettings topSlide;
    protected final ModernBetaNoiseSettings.SlideSettings bottomSlide;
    protected final ChunkCache<NoiseSource> noiseCache;
    protected final ChunkCache<HeightmapChunk> heightmapCache;
    private Optional<PerlinOctaveNoise> forestOctaveNoise;
    private Optional<PerlinOctaveNoise> beachOctaveNoise;

    public NoiseChunkSource(World world, ModernBetaChunkGenerator chunkGenerator, ModernBetaChunkGeneratorSettings settings, long seed, boolean mapFeaturesEnabled, ModernBetaNoiseSettings noiseSettings) {
        super(world, chunkGenerator, settings, seed, mapFeaturesEnabled);
        this.defaultFluid = settings.useLavaOceans ? BlockStates.LAVA : BlockStates.WATER;
        this.worldMinY = 0;
        this.worldHeight = settings.height;
        this.worldTopY = this.worldMinY + this.worldHeight;
        this.seaLevel = settings.seaLevel;
        this.bedrockFloor = 0;
        this.bedrockCeiling = -10;
        this.verticalNoiseResolution = noiseSettings.sizeVertical * 4;
        this.horizontalNoiseResolution = noiseSettings.sizeHorizontal * 4;
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = Math.floorDiv(this.worldHeight, this.verticalNoiseResolution);
        this.noiseTopY = Math.floorDiv(this.worldTopY, this.verticalNoiseResolution);
        this.topSlide = noiseSettings.topSlideSettings;
        this.bottomSlide = noiseSettings.bottomSlideSettings;
        this.noiseCache = new ChunkCache<NoiseSource>("noise", 512, true, (chunkX, chunkZ) -> {
            NoiseSource noiseSource = new NoiseSource(this::sampleNoiseColumn, this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ);
            noiseSource.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ);
            return noiseSource;
        });
        this.heightmapCache = new ChunkCache<HeightmapChunk>("heightmap", 512, true, this::sampleHeightmap);
        this.forestOctaveNoise = Optional.empty();
        this.beachOctaveNoise = Optional.empty();
    }

    @Override
    public void provideBaseChunk(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        this.generateTerrain(chunkPrimer, chunkX, chunkZ);
    }

    @Override
    public int getHeight(int x, int z, HeightmapChunk.Type type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.heightmapCache.get(chunkX, chunkZ).getHeight(x, z, type);
    }

    public Optional<PerlinOctaveNoise> getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    public Optional<PerlinOctaveNoise> getBeachOctaveNoise() {
        return this.beachOctaveNoise;
    }

    protected abstract void sampleNoiseColumn(double[] var1, int var2, int var3, int var4, int var5);

    protected double applySlides(double density, int noiseY) {
        double delta;
        if ((double)this.topSlide.slideSize > 0.0) {
            delta = ((double)(this.noiseSizeY - noiseY) - (double)this.topSlide.slideOffset) / (double)this.topSlide.slideSize;
            density = MathUtil.clampedLerp(this.topSlide.slideTarget, density, delta);
        }
        if ((double)this.bottomSlide.slideSize > 0.0) {
            delta = ((double)noiseY - (double)this.bottomSlide.slideOffset) / (double)this.bottomSlide.slideSize;
            density = MathUtil.clampedLerp(this.bottomSlide.slideTarget, density, delta);
        }
        return density;
    }

    protected void setForestOctaveNoise(PerlinOctaveNoise forestNoiseOctaves) {
        this.forestOctaveNoise = Optional.ofNullable(forestNoiseOctaves);
    }

    protected void setBeachOctaveNoise(PerlinOctaveNoise beachOctaveNoise) {
        this.beachOctaveNoise = Optional.ofNullable(beachOctaveNoise);
    }

    private void generateTerrain(ChunkPrimer chunkPrimer, int chunkX, int chunkZ) {
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        ArrayList<NoiseSource> noiseSources = new ArrayList<NoiseSource>();
        NoiseSource baseNoiseSource = this.noiseCache.get(chunkX, chunkZ);
        BlockSource baseBlockSource = this.getBaseBlockSource(baseNoiseSource);
        BlockSourceRules blockSources = new BlockSourceRules.Builder().add(baseBlockSource).build(this.defaultBlock);
        noiseSources.forEach(noiseSource -> noiseSource.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ));
        noiseSources.add(baseNoiseSource);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            int noiseX = subChunkX;
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                int noiseZ = subChunkZ;
                for (int subChunkY = 0; subChunkY < this.noiseSizeY; ++subChunkY) {
                    int noiseY = subChunkY;
                    noiseSources.forEach(noiseProvider -> noiseProvider.sampleNoiseCorners(noiseX, noiseY, noiseZ));
                    for (int subY = 0; subY < this.verticalNoiseResolution; ++subY) {
                        int y = subY + subChunkY * this.verticalNoiseResolution;
                        double deltaY = (double)subY / (double)this.verticalNoiseResolution;
                        noiseSources.forEach(noiseProvider -> noiseProvider.sampleNoiseY(deltaY));
                        for (int subX = 0; subX < this.horizontalNoiseResolution; ++subX) {
                            int localX = subX + subChunkX * this.horizontalNoiseResolution;
                            int x = startX + localX;
                            double deltaX = (double)subX / (double)this.horizontalNoiseResolution;
                            noiseSources.forEach(noiseProvider -> noiseProvider.sampleNoiseX(deltaX));
                            for (int subZ = 0; subZ < this.horizontalNoiseResolution; ++subZ) {
                                int localZ = subZ + subChunkZ * this.horizontalNoiseResolution;
                                int z = startZ + localZ;
                                double deltaZ = (double)subZ / (double)this.horizontalNoiseResolution;
                                noiseSources.forEach(noiseProvider -> noiseProvider.sampleNoiseZ(deltaZ));
                                IBlockState blockState = blockSources.sample(x, y, z);
                                if (blockState.equals(BlockStates.AIR)) continue;
                                chunkPrimer.func_177855_a(localX, y, localZ, blockState);
                            }
                        }
                    }
                }
            }
        }
    }

    private HeightmapChunk sampleHeightmap(int chunkX, int chunkZ) {
        short minHeight = 0;
        short worldMinY = (short)this.worldMinY;
        short worldTopY = (short)this.worldTopY;
        NoiseSource noiseSource = this.noiseCache.get(chunkX, chunkZ);
        short[] heightmapSurface = new short[256];
        short[] heightmapOcean = new short[256];
        short[] heightmapFloor = new short[256];
        Arrays.fill(heightmapSurface, minHeight);
        Arrays.fill(heightmapOcean, minHeight);
        Arrays.fill(heightmapFloor, worldMinY);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                for (int subChunkY = 0; subChunkY < this.noiseSizeY; ++subChunkY) {
                    noiseSource.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                    for (int subY = 0; subY < this.verticalNoiseResolution; ++subY) {
                        int y = subY + subChunkY * this.verticalNoiseResolution;
                        y += this.worldMinY;
                        double deltaY = (double)subY / (double)this.verticalNoiseResolution;
                        noiseSource.sampleNoiseY(deltaY);
                        for (int subX = 0; subX < this.horizontalNoiseResolution; ++subX) {
                            int x = subX + subChunkX * this.horizontalNoiseResolution;
                            double deltaX = (double)subX / (double)this.horizontalNoiseResolution;
                            noiseSource.sampleNoiseX(deltaX);
                            for (int subZ = 0; subZ < this.horizontalNoiseResolution; ++subZ) {
                                int z = subZ + subChunkZ * this.horizontalNoiseResolution;
                                double deltaZ = (double)subZ / (double)this.horizontalNoiseResolution;
                                noiseSource.sampleNoiseZ(deltaZ);
                                double density = noiseSource.sample();
                                boolean isSolid = density > 0.0;
                                short height = (short)y;
                                int ndx = z + x * 16;
                                if (y < this.seaLevel || isSolid) {
                                    heightmapOcean[ndx] = height;
                                }
                                if (isSolid) {
                                    heightmapSurface[ndx] = height;
                                }
                                if (isSolid && heightmapFloor[ndx] == worldMinY) {
                                    heightmapFloor[ndx] = worldTopY;
                                }
                                if (isSolid || heightmapFloor[ndx] != worldTopY) continue;
                                heightmapFloor[ndx] = (short)(height - 1);
                            }
                        }
                    }
                }
            }
        }
        return new HeightmapChunk(heightmapSurface, heightmapOcean, heightmapFloor);
    }

    private BlockSource getBaseBlockSource(NoiseSource noiseSource) {
        return (x, y, z) -> {
            double density = noiseSource.sample();
            IBlockState blockState = BlockStates.AIR;
            if (density > 0.0) {
                blockState = this.defaultBlock;
            } else if (y < this.seaLevel) {
                blockState = this.defaultFluid;
            }
            return blockState;
        };
    }
}

