/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.gen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.api.world.biome.climate.ClimateSampler;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.SimplexOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeLists;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjector;
import mod.bespectacled.modernbetaforge.world.carver.MapGenBetaCave;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGeneratorSettings;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaMapGenScatteredFeature;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaStructureOceanMonument;
import mod.bespectacled.modernbetaforge.world.structure.ModernBetaWoodlandMansion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class ChunkSource {
    private static final Set<Biome> BIOMES_WITH_CUSTOM_SURFACES = new HashSet<Biome>(ModernBetaBiomeLists.BIOMES_WITH_CUSTOM_SURFACES);
    protected final ModernBetaChunkGenerator chunkGenerator;
    protected final ModernBetaChunkGeneratorSettings settings;
    protected final World world;
    protected final long seed;
    protected final boolean mapFeaturesEnabled;
    protected final Random random;
    private final MapGenBase caveCarver;
    private final MapGenBase ravineCarver;
    private final MapGenStronghold strongholdGenerator;
    private final MapGenVillage villageGenerator;
    private final MapGenMineshaft mineshaftGenerator;
    private final ModernBetaMapGenScatteredFeature scatteredFeatureGenerator;
    private final ModernBetaStructureOceanMonument oceanMonumentGenerator;
    private final ModernBetaWoodlandMansion woodlandMansionGenerator;
    private final Biome[] biomes;
    private final BiomeInjector biomeInjector;
    private final SimplexOctaveNoise surfaceOctaveNoise;

    public ChunkSource(World world, ModernBetaChunkGenerator chunkGenerator, ModernBetaChunkGeneratorSettings chunkGeneratorSettings, long seed, boolean mapFeaturesEnabled) {
        this.chunkGenerator = chunkGenerator;
        this.settings = chunkGeneratorSettings;
        this.world = world;
        this.seed = seed;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        this.random = new Random(seed);
        this.caveCarver = TerrainGen.getModdedMapGen((MapGenBase)new MapGenBetaCave(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineCarver = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = new ModernBetaMapGenScatteredFeature();
        this.oceanMonumentGenerator = new ModernBetaStructureOceanMonument();
        this.woodlandMansionGenerator = new ModernBetaWoodlandMansion(chunkGenerator);
        this.biomes = new Biome[256];
        this.biomeInjector = world.func_72959_q() instanceof ModernBetaBiomeProvider ? new BiomeInjector(this, ((ModernBetaBiomeProvider)world.func_72959_q()).getBiomeSource()) : null;
        this.surfaceOctaveNoise = new SimplexOctaveNoise(new Random(seed), 4);
        this.world.func_181544_b(this.settings.seaLevel);
        if (this.world.func_72959_q() instanceof ModernBetaBiomeProvider) {
            ModernBetaBiomeProvider biomeProvider = (ModernBetaBiomeProvider)this.world.func_72959_q();
            biomeProvider.setChunkSource(this);
        }
    }

    public abstract void provideBaseChunk(ChunkPrimer var1, int var2, int var3);

    public abstract void provideSurface(Biome[] var1, ChunkPrimer var2, int var3, int var4);

    public abstract int getHeight(int var1, int var2, HeightmapChunk.Type var3);

    public Chunk provideChunk(int chunkX, int chunkZ) {
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.provideBaseChunk(chunkPrimer, chunkX, chunkZ);
        this.world.func_72959_q().func_76933_b(this.biomes, startX, startZ, 16, 16);
        this.provideSurface(this.biomes, chunkPrimer, chunkX, chunkZ);
        if (this.biomeInjector != null) {
            this.biomeInjector.getInjectedBiomes(this.biomes, chunkPrimer, chunkX, chunkZ);
        }
        if (this.settings.useCaves) {
            this.caveCarver.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
        }
        if (this.settings.useRavines) {
            this.ravineCarver.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
        }
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkPrimer);
            }
        }
        Chunk chunk = new Chunk(this.world, chunkPrimer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomes[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void populateChunk(int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        BlockFalling.field_149832_M = true;
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        boolean hasVillageGenerated = false;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Biome biome = this.world.func_180494_b(new BlockPos(startX + 16, 0, startZ + 16));
        this.random.setSeed(this.world.func_72905_C());
        long randomLong0 = this.random.nextLong() / 2L * 2L + 1L;
        long randomLong1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ this.world.func_72905_C());
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
            if (this.settings.useVillages) {
                hasVillageGenerated = this.villageGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_175794_a(this.world, this.random, chunkPos);
            }
        }
        this.random.setSeed(this.world.func_72905_C());
        randomLong0 = this.random.nextLong() / 2L * 2L + 1L;
        randomLong1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)chunkX * randomLong0 + (long)chunkZ * randomLong1 ^ this.world.func_72905_C());
        if (!hasVillageGenerated && this.settings.useWaterLakes && TerrainGen.populate((IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE) && this.random.nextInt(this.settings.waterLakeChance) == 0) {
            x = startX + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = startZ + this.random.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.random, (BlockPos)mutablePos.func_181079_c(x, y, z));
        }
        if (!hasVillageGenerated && this.settings.useLavaLakes && TerrainGen.populate((IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && this.random.nextInt(this.settings.lavaLakeChance / 10) == 0) {
            x = startX + this.random.nextInt(16) + 8;
            y = this.random.nextInt(this.random.nextInt(120) + 8);
            z = startZ + this.random.nextInt(16) + 8;
            if (y < 64 || this.random.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.random, (BlockPos)mutablePos.func_181079_c(x, y, z));
            }
        }
        if (this.settings.useDungeons && TerrainGen.populate((IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int i = 0; i < this.settings.dungeonChance; ++i) {
                int x2 = startX + this.random.nextInt(16) + 8;
                int y2 = this.random.nextInt(128);
                int z2 = startZ + this.random.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.random, (BlockPos)mutablePos.func_181079_c(x2, y2, z2));
            }
        }
        biome.func_180624_a(this.world, this.random, new BlockPos(startX, 0, startZ));
        if (TerrainGen.populate((IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(startX + 8), (int)(startZ + 8), (int)16, (int)16, (Random)this.random);
        }
        ModernBetaBiomeProvider biomeProvider = (ModernBetaBiomeProvider)this.world.func_72959_q();
        if (TerrainGen.populate((IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int dX = 0; dX < 16; ++dX) {
                for (int dZ = 0; dZ < 16; ++dZ) {
                    int x3 = dX + startX + 8;
                    int z3 = dZ + startZ + 8;
                    int y3 = this.world.func_175725_q((BlockPos)mutablePos.func_181079_c(x3, 0, z3)).func_177956_o();
                    BlockPos blockPosDown = mutablePos.func_181079_c(x3, y3, z3).func_177977_b();
                    if (biomeProvider.getBiomeSource() instanceof ClimateSampler) {
                        ClimateSampler climateSampler = (ClimateSampler)((Object)biomeProvider.getBiomeSource());
                        double temp = climateSampler.sample(x3, z3).temp();
                        if (BiomeBeta.canSetIce(this.world, blockPosDown, false, temp -= (double)(y3 - 64) / 64.0 * 0.3)) {
                            this.world.func_180501_a(blockPosDown, Blocks.field_150432_aD.func_176223_P(), 2);
                        }
                        if (!BiomeBeta.canSetSnow(this.world, (BlockPos)mutablePos, temp)) continue;
                        this.world.func_180501_a((BlockPos)mutablePos, Blocks.field_150431_aC.func_176223_P(), 2);
                        continue;
                    }
                    if (this.world.func_175675_v(blockPosDown)) {
                        this.world.func_180501_a(blockPosDown, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f((BlockPos)mutablePos, true)) continue;
                    this.world.func_180501_a((BlockPos)mutablePos, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this.chunkGenerator, (World)this.world, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean generateStructures(Chunk chunk, int chunkX, int chunkZ) {
        boolean generated = false;
        if (this.settings.useMonuments && this.mapFeaturesEnabled && chunk.func_177416_w() < 3600L) {
            generated |= this.oceanMonumentGenerator.func_175794_a(this.world, this.random, new ChunkPos(chunkX, chunkZ));
        }
        return generated;
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        Biome biome = this.world.func_180494_b(blockPos);
        if (this.mapFeaturesEnabled) {
            if (enumCreatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(blockPos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (enumCreatureType == EnumCreatureType.MONSTER && this.settings.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.world, blockPos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biome.func_76747_a(enumCreatureType);
    }

    public boolean isInsideStructure(World world, String structureName, BlockPos blockPos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(blockPos);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_175795_b(blockPos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(blockPos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(blockPos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(blockPos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null && this.scatteredFeatureGenerator.func_175795_b(blockPos);
    }

    public BlockPos getNearestStructurePos(World world, String structureName, BlockPos blockPos, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(world, blockPos, findUnexplored);
        }
        if ("Mansion".equals(structureName) && this.woodlandMansionGenerator != null) {
            return this.woodlandMansionGenerator.func_180706_b(world, blockPos, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(world, blockPos, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(world, blockPos, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, blockPos, findUnexplored);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(world, blockPos, findUnexplored) : null;
    }

    public void recreateStructures(Chunk chunk, int chunkX, int chunkZ) {
        if (this.mapFeaturesEnabled) {
            if (this.settings.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useVillages) {
                this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
            if (this.settings.useMansions) {
                this.woodlandMansionGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
            }
        }
    }

    public int getSeaLevel() {
        return this.settings.seaLevel;
    }

    public Biome getInjectedBiomeFast(int x, int z) {
        if (this.biomeInjector != null) {
            return this.biomeInjector.getInjectedBiomeFast(x, z);
        }
        return null;
    }

    public ModernBetaChunkGeneratorSettings getChunkGeneratorSettings() {
        return this.settings;
    }

    protected Random createSurfaceRandom(int chunkX, int chunkZ) {
        long seed = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        return new Random(seed);
    }

    protected boolean useCustomSurfaceBuilder(Biome biome, ChunkPrimer chunkPrimer, Random random, int x, int z) {
        if (BIOMES_WITH_CUSTOM_SURFACES.contains(biome)) {
            double surfaceNoise = this.surfaceOctaveNoise.sample(x, z, 0.0625, 0.0625, 1.0);
            biome.func_180622_a(this.world, random, chunkPrimer, z, x, surfaceNoise);
            return true;
        }
        return false;
    }

    static {
        BIOMES_WITH_CUSTOM_SURFACES.addAll(Arrays.asList(ModernBetaConfig.generatorOptions.biomesWithCustomSurfaces).stream().map(str -> (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(str))).collect(Collectors.toList()));
    }
}

