/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge;

import java.util.Random;
import mod.bespectacled.modernbetaforge.ModernBetaProxy;
import mod.bespectacled.modernbetaforge.api.world.biome.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.gen.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.gen.NoiseChunkSource;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.util.noise.PerlinOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeStructures;
import mod.bespectacled.modernbetaforge.world.biome.beta.BiomeBetaDesert;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaChunkGenerator;
import mod.bespectacled.modernbetaforge.world.gen.ModernBetaWorldType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="modernbetaforge", name="Modern Beta Forge", version="1.0.2.1", acceptedMinecraftVersions="1.12.2")
public class ModernBeta {
    public static final String MODID = "modernbetaforge";
    public static final String NAME = "Modern Beta Forge";
    public static final String VERSION = "1.0.2.1";
    public static final String MCVERSION = "1.12.2";
    private static Logger logger = LogManager.getLogger((String)"modernbetaforge");
    @SidedProxy(clientSide="mod.bespectacled.modernbetaforge.ModernBetaClientProxy", serverSide="mod.bespectacled.modernbetaforge.ModernBetaCommonProxy")
    public static ModernBetaProxy proxy;

    public static void log(Level level, String message) {
        logger.log(level, "{}", (Object)message);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.initColors();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModernBetaWorldType.register();
        ModernBetaBiomeStructures.registerStructures();
        ModernBetaBiomeStructures.registerStructureBiomes();
        proxy.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        WorldServer worldServer = server.func_184102_h().func_71218_a(0);
        IChunkGenerator chunkGenerator = worldServer.func_72863_F().field_186029_c;
        BiomeProvider biomeProvider = worldServer.func_72959_q();
        BlockPos currentSpawnPos = worldServer.func_175694_M();
        int spawnX = currentSpawnPos.func_177958_n();
        int spawnZ = currentSpawnPos.func_177952_p();
        if (chunkGenerator instanceof ModernBetaChunkGenerator && biomeProvider instanceof ModernBetaBiomeProvider) {
            ChunkSource chunkSource = ((ModernBetaChunkGenerator)chunkGenerator).getChunkSource();
            BiomeSource biomeSource = ((ModernBetaBiomeProvider)biomeProvider).getBiomeSource();
            if (chunkSource instanceof NoiseChunkSource && ((NoiseChunkSource)chunkSource).getBeachOctaveNoise().isPresent()) {
                int y;
                BlockPos newSpawnPos;
                NoiseChunkSource noiseChunkSource = (NoiseChunkSource)chunkSource;
                PerlinOctaveNoise beachOctaveNoise = noiseChunkSource.getBeachOctaveNoise().get();
                int x = 0;
                int z = 0;
                int attempts = 0;
                Random random = new Random();
                while (!this.isSandAt(x, z, chunkSource, biomeSource, beachOctaveNoise)) {
                    if (attempts > 10000) {
                        x = 0;
                        z = 0;
                        break;
                    }
                    x += random.nextInt(64) - random.nextInt(64);
                    z += random.nextInt(64) - random.nextInt(64);
                    ++attempts;
                }
                if (!(newSpawnPos = new BlockPos(x, y = chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE) + 1, z)).equals((Object)currentSpawnPos)) {
                    worldServer.func_175652_B(new BlockPos(x, y, z));
                }
            } else {
                worldServer.func_175652_B(this.findSpawnInRadius(chunkSource, spawnX, spawnZ, 64));
            }
        }
    }

    private boolean isSandAt(int x, int z, ChunkSource chunkSource, BiomeSource biomeSource, PerlinOctaveNoise beachOctaveNoise) {
        int seaLevel = chunkSource.getSeaLevel();
        int y = chunkSource.getHeight(x, z, HeightmapChunk.Type.SURFACE);
        Biome biome = biomeSource.getBiome(x, z);
        return biome instanceof BiomeBetaDesert && y >= seaLevel - 1 || beachOctaveNoise.sample((double)x * 0.03125, (double)z * 0.03125, 0.0) > 0.0 && y >= seaLevel - 1 && y < seaLevel + 2;
    }

    private BlockPos findSpawnInRadius(ChunkSource chunkSource, int x, int z, int radius) {
        int r2 = radius * radius;
        for (int dX = x - radius; dX < x + radius; ++dX) {
            for (int dZ = z - radius; dZ < z + radius; ++dZ) {
                int y;
                double distance = MathUtil.distance(x, z, dX, dZ);
                if (!(distance < (double)r2) || (y = chunkSource.getHeight(dX, dZ, HeightmapChunk.Type.SURFACE)) <= 16) continue;
                return new BlockPos(dX, y + 1, dZ);
            }
        }
        return this.findSpawnInRadius(chunkSource, x, z, radius * 2);
    }
}

