/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.core.mixin;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.EntitySize;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.integration.artemislib.ArtemisLibIntegration;
import com.fuzs.aquaacrobatics.integration.betweenlands.BetweenlandsIntegration;
import com.fuzs.aquaacrobatics.integration.chiseledme.ChiseledMeIntegration;
import com.fuzs.aquaacrobatics.integration.morph.MorphIntegration;
import com.fuzs.aquaacrobatics.integration.trinketsandbaubles.TrinketsAndBaublesIntegration;
import com.fuzs.aquaacrobatics.integration.wings.WingsIntegration;
import com.fuzs.aquaacrobatics.integration.witchery.WitcheryResurrectedIntegration;
import com.fuzs.aquaacrobatics.network.datasync.PoseSerializer;
import com.fuzs.aquaacrobatics.util.math.MathHelperNew;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements IPlayerResizeable {
    private static final EntitySize STANDING_SIZE = EntitySize.flexible(0.6f, 1.8f);
    private static final Map<Pose, EntitySize> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.SLEEPING, (Object)EntitySize.fixed(0.2f, 0.2f)).put((Object)Pose.FALL_FLYING, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.flexible(0.6f, 0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.flexible(0.6f, 1.5f)).put((Object)Pose.DYING, (Object)EntitySize.fixed(0.2f, 0.2f)).build();
    private static final DataParameter<Pose> POSE = EntityDataManager.func_187226_a(EntityPlayer.class, PoseSerializer.POSE);
    private static final DataParameter<Boolean> TOGGLED_CRAWLING = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    @Shadow
    public PlayerCapabilities field_71075_bZ;
    @Shadow
    public float field_71107_bF;
    @Shadow
    public float field_71109_bG;
    @Shadow(remap=false)
    @Final
    public float eyeHeight;
    protected boolean eyesInWater;
    protected boolean eyesInWaterPlayer;
    private EntitySize size;
    private float playerEyeHeight;
    private float previousEyeHeight;
    private float swimAnimation;
    private float lastSwimAnimation;
    private float timeUnderwater;
    private boolean inBubbleColumn;

    public EntityPlayerMixin(World worldIn) {
        super(worldIn);
    }

    private float findEntitySizeScaleFactor() {
        float finalFactor = 1.0f;
        if (IntegrationManager.isTrinketsAndBaublesEnabled()) {
            finalFactor *= TrinketsAndBaublesIntegration.getResizeFactor((EntityPlayer)this);
        }
        if (IntegrationManager.isChiseledMeEnabled()) {
            finalFactor *= ChiseledMeIntegration.getResizeFactor((EntityPlayer)this);
        }
        return finalFactor;
    }

    private float findEyeScaleFactor() {
        float finalFactor = 1.0f;
        if (IntegrationManager.isArtemisLibEnabled()) {
            finalFactor *= ArtemisLibIntegration.getEyeFactor((EntityPlayer)this);
        }
        if (IntegrationManager.isChiseledMeEnabled()) {
            finalFactor *= ChiseledMeIntegration.getResizeFactor((EntityPlayer)this);
        }
        return finalFactor;
    }

    private EntitySize handleEntitySizeScaling(EntitySize in) {
        float finalFactor = this.findEntitySizeScaleFactor();
        if (finalFactor == 1.0f) {
            return in;
        }
        return in.scale(finalFactor);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo callbackInfo) {
        this.size = this.handleEntitySizeScaling(EntitySize.flexible(0.6f, 1.8f));
        this.playerEyeHeight = this.getEyeHeight(Pose.STANDING, this.size);
        this.field_70180_af.func_187214_a(POSE, (Object)Pose.STANDING);
        if (ConfigHandler.MovementConfig.enableToggleCrawling) {
            this.field_70180_af.func_187214_a(TOGGLED_CRAWLING, (Object)false);
        }
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        if (POSE.equals(key)) {
            this.recalculateEyeHeight();
            this.recalculateSize();
            if (IntegrationManager.isArtemisLibEnabled()) {
                ArtemisLibIntegration.updateSwimmingSize(this.getPlayer(), this.getPose());
            }
        }
        super.func_184206_a(key);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (IntegrationManager.isWitcheryResurrectedEnabled() && WitcheryResurrectedIntegration.HAS_TRANSFORMED) {
            this.playerEyeHeight = this.getEyeHeight(Pose.STANDING, this.size);
            WitcheryResurrectedIntegration.HAS_TRANSFORMED = false;
        } else if (this.func_70090_H()) {
            int i = this.func_175149_v() ? 10 : 1;
            this.timeUnderwater = MathHelper.func_76131_a((float)(this.timeUnderwater + (float)i), (float)0.0f, (float)600.0f);
        } else if (this.timeUnderwater > 0.0f) {
            this.timeUnderwater = MathHelper.func_76131_a((float)(this.timeUnderwater - 10.0f), (float)0.0f, (float)600.0f);
        }
        this.updateEyesInWater();
        this.updateSwimming();
    }

    @Override
    public float getWaterVision() {
        if (!this.func_70090_H()) {
            return 0.0f;
        }
        float f = 600.0f;
        float f1 = 100.0f;
        if (this.timeUnderwater >= 600.0f) {
            return 1.0f;
        }
        float f2 = MathHelper.func_76131_a((float)(this.timeUnderwater / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = this.timeUnderwater < 100.0f ? 0.0f : MathHelper.func_76131_a((float)((this.timeUnderwater - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    @Override
    public boolean canForceCrawling() {
        return ConfigHandler.MovementConfig.enableToggleCrawling && !this.func_184218_aH() && !this.field_71075_bZ.field_75100_b && !this.func_70617_f_();
    }

    @Override
    public boolean isForcingCrawling() {
        return this.canForceCrawling() && (Boolean)this.field_70180_af.func_187225_a(TOGGLED_CRAWLING) != false;
    }

    @Override
    public void setForcingCrawling(boolean flag) {
        if (!this.canForceCrawling()) {
            return;
        }
        this.field_70180_af.func_187227_b(TOGGLED_CRAWLING, (Object)flag);
    }

    @Override
    public boolean canSwim() {
        return this.eyesInWater && this.func_70090_H();
    }

    @Override
    public void updateSwimming() {
        if (this.field_71075_bZ.field_75100_b) {
            this.setSwimming(false);
        } else if (this.isSwimming()) {
            this.setSwimming(this.func_70051_ag() && this.func_70090_H() && !this.func_184218_aH());
        } else {
            this.setSwimming(this.func_70051_ag() && this.canSwim() && !this.func_184218_aH());
        }
    }

    private void updateEyesInWater() {
        this.eyesInWater = this.func_70055_a(Material.field_151586_h);
    }

    protected boolean updateEyesInWaterPlayer() {
        this.eyesInWaterPlayer = this.func_70055_a(Material.field_151586_h);
        return this.eyesInWaterPlayer;
    }

    @Override
    public boolean getEyesInWaterPlayer() {
        return this.eyesInWaterPlayer;
    }

    @Override
    public final float getWidth() {
        return this.size.width;
    }

    @Override
    public final float getHeight() {
        return this.size.height;
    }

    @Override
    public EntitySize getSize(Pose poseIn) {
        return this.handleEntitySizeScaling(SIZE_BY_POSE.getOrDefault((Object)poseIn, STANDING_SIZE));
    }

    @Override
    public void recalculateSize() {
        EntitySize oldSize = this.size;
        Pose pose = this.getPose();
        EntitySize newSize = this.getSize(pose);
        if (this.isResizingAllowed()) {
            this.recalculateSize(oldSize, newSize);
            this.field_70130_N = newSize.width;
            this.field_70131_O = newSize.height;
        }
        this.size = newSize;
    }

    protected void recalculateSize(EntitySize oldSize, EntitySize newSize) {
        if (newSize.width < oldSize.width) {
            double d0 = (double)newSize.width / 2.0;
            this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)newSize.height, this.field_70161_v + d0));
        } else {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)newSize.width, axisalignedbb.field_72338_b + (double)newSize.height, axisalignedbb.field_72339_c + (double)newSize.width));
            if (newSize.width > oldSize.width && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                float distance = oldSize.width - newSize.width;
                this.func_70091_d(MoverType.SELF, distance, 0.0, distance);
            }
        }
    }

    private void recalculateEyeHeight() {
        Pose pose = this.getPose();
        EntitySize entitysize = this.getSize(pose);
        this.playerEyeHeight = this.getEyeHeight(pose, entitysize);
        this.previousEyeHeight = this.eyeHeight;
    }

    @Override
    public boolean isResizingAllowed() {
        if (IntegrationManager.isMorphEnabled() && MorphIntegration.isMorphing(this.getPlayer())) {
            return false;
        }
        float delta = 0.025f;
        AxisAlignedBB bb = this.func_174813_aQ();
        if (this.field_70130_N < 0.025f || this.field_70131_O < 0.025f || bb.field_72336_d - bb.field_72340_a < (double)0.025f || bb.field_72337_e - bb.field_72338_b < (double)0.025f) {
            return true;
        }
        boolean sizeIsOk = Math.abs(this.field_70130_N / this.getWidth() - 1.0f) < 0.025f && Math.abs(this.field_70131_O / this.getHeight() - 1.0f) < 0.025f;
        boolean boundingBoxIsOk = Math.abs((bb.field_72336_d - bb.field_72340_a) / (double)this.getWidth() - 1.0) < (double)0.025f && Math.abs((bb.field_72337_e - bb.field_72338_b) / (double)this.getHeight() - 1.0) < (double)0.025f;
        return sizeIsOk && boundingBoxIsOk;
    }

    protected float getEyeHeight(Pose poseIn, EntitySize sizeIn) {
        if (IntegrationManager.isWitcheryResurrectedEnabled()) {
            switch (WitcheryResurrectedIntegration.getCurrentTransformation()) {
                case BAT: 
                case WOLF: {
                    return 0.5f;
                }
            }
        }
        return poseIn == Pose.SLEEPING || poseIn == Pose.DYING ? 0.2f : this.getStandingEyeHeight(poseIn, sizeIn);
    }

    @Override
    public boolean isActuallySneaking() {
        return this.func_70093_af();
    }

    @Override
    public float getStandingEyeHeight(Pose poseIn, EntitySize sizeIn) {
        switch (poseIn) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return this.eyeHeight - (this.isResizingAllowed() ? 0.35f : 0.08f);
            }
        }
        return this.eyeHeight;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public final void getEyeHeight(CallbackInfoReturnable<Float> callbackInfoReturnable) {
        callbackInfoReturnable.setReturnValue((Object)Float.valueOf(this.playerEyeHeight * this.findEyeScaleFactor()));
    }

    @Shadow
    public abstract boolean func_175149_v();

    @Override
    public void setPose(Pose poseIn) {
        this.field_70180_af.func_187227_b(POSE, (Object)poseIn);
    }

    @Override
    public Pose getPose() {
        return (Pose)((Object)this.field_70180_af.func_187225_a(POSE));
    }

    @Override
    public boolean isPoseClear(Pose poseIn) {
        if (poseIn == Pose.CROUCHING && IntegrationManager.isBetweenlandsEnabled() && BetweenlandsIntegration.couldPlayerPhase((EntityPlayer)this)) {
            return true;
        }
        return this.field_70170_p.func_184144_a((Entity)this, this.getBoundingBox(poseIn)).isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70065_x() {
        this.setPose(Pose.STANDING);
        super.func_70065_x();
        this.func_70606_j(this.func_110138_aP());
        this.field_70725_aQ = 0;
    }

    @Inject(method={"updateSize"}, at={@At(value="HEAD")}, cancellable=true)
    protected void updateSize(CallbackInfo callbackInfo) {
        this.updateSwimAnimation();
        this.updateEyesInWaterPlayer();
        FMLCommonHandler.instance().onPlayerPostTick(this.getPlayer());
        this.updatePose();
        this.updateEyeHeight();
        callbackInfo.cancel();
    }

    protected void updatePose() {
        if (this.getShouldBeDead()) {
            this.setPose(Pose.DYING);
        } else if (this.func_70608_bn()) {
            this.setPose(Pose.SLEEPING);
        } else if (this.isPoseClear(Pose.SWIMMING)) {
            Pose pose = (IntegrationManager.isWingsEnabled() ? WingsIntegration.onFlightCheck(this.getPlayer(), this.func_184613_cA()) : this.func_184613_cA()) ? Pose.FALL_FLYING : (this.isForcingCrawling() || this.isSwimming() ? Pose.SWIMMING : (this.isActuallySneaking() && !this.field_71075_bZ.field_75100_b && (this.field_70122_E || !this.func_70090_H()) && !this.func_70617_f_() ? Pose.CROUCHING : Pose.STANDING));
            Pose pose1 = !this.field_70145_X && !this.func_184218_aH() && this.isResizingAllowed() && !this.isPoseClear(pose) ? (this.isPoseClear(Pose.CROUCHING) ? Pose.CROUCHING : (ConfigHandler.MovementConfig.enableCrawling ? Pose.SWIMMING : Pose.STANDING)) : pose;
            this.setPose(pose1);
        }
    }

    private void updateEyeHeight() {
        if (this.eyeHeight != this.previousEyeHeight) {
            this.recalculateEyeHeight();
        }
    }

    protected AxisAlignedBB getBoundingBox(Pose p_213321_1_) {
        EntitySize entitysize = this.getSize(p_213321_1_);
        float f = entitysize.width / 2.0f;
        return new AxisAlignedBB(this.field_70165_t - (double)f, this.field_70163_u, this.field_70161_v - (double)f, this.field_70165_t + (double)f, this.field_70163_u + (double)entitysize.height, this.field_70161_v + (double)f);
    }

    @Override
    public boolean getShouldBeDead() {
        return this.func_110143_aJ() <= 0.0f;
    }

    @Override
    public boolean isSwimming() {
        return !this.field_71075_bZ.field_75100_b && !this.func_175149_v() && this.func_70083_f(4);
    }

    @Override
    public boolean isActuallySwimming() {
        boolean isFallFlying;
        boolean bl = isFallFlying = !this.func_184613_cA() && this.getPose() == Pose.FALL_FLYING;
        return this.getPose() == Pose.SWIMMING || (IntegrationManager.isWingsEnabled() ? !WingsIntegration.onFlightCheck(this.getPlayer(), !isFallFlying) : isFallFlying);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isVisuallySwimming() {
        return this.isActuallySwimming() && !this.func_70090_H();
    }

    @Override
    public void setSwimming(boolean flag) {
        this.func_70052_a(4, flag);
    }

    @Override
    public float getSwimAnimation(float partialTicks) {
        return MathHelperNew.lerp(partialTicks, this.lastSwimAnimation, this.swimAnimation);
    }

    private void updateSwimAnimation() {
        this.lastSwimAnimation = this.swimAnimation;
        this.swimAnimation = this.isActuallySwimming() ? Math.min(1.0f, this.swimAnimation + 0.09f) : Math.max(0.0f, this.swimAnimation - 0.09f);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    public void travel(float strafe, float vertical, float forward, CallbackInfo callbackInfo) {
        double d3;
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        if (this.isSwimming() && !this.func_184218_aH()) {
            d3 = this.func_70040_Z().field_72448_b;
            double d4 = d3 < -0.2 ? 0.085 : 0.06;
            IBlockState fluidState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0 - 0.1, this.field_70161_v));
            if (d3 <= 0.0 || this.field_70703_bu || fluidState.func_177230_c() instanceof BlockLiquid || fluidState.func_177230_c() instanceof IFluidBlock) {
                double d5 = this.field_70181_x;
                this.field_70181_x += (d3 - d5) * d4;
            }
        }
        d3 = this.field_70181_x;
        float f = this.field_70747_aH;
        if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
            this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
        }
        if (!this.field_71075_bZ.field_75100_b && this.func_70090_H()) {
            if (this.func_70613_aW() || this.func_184186_bw()) {
                double d8 = this.field_70163_u;
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                this.func_191958_b(strafe, vertical, forward, f6);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (this.field_70123_F && this.func_70617_f_()) {
                    this.field_70181_x = 0.2;
                }
                this.field_70159_w *= (double)f5;
                this.field_70181_x *= 0.8;
                this.field_70179_y *= (double)f5;
                this.applyGravity();
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + 0.6 - this.field_70163_u + d8, this.field_70179_y)) {
                    this.field_70181_x = 0.3;
                }
                this.updateLimbSwing();
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
        if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
            this.field_70181_x = d3 * 0.6;
            this.field_70747_aH = f;
            this.field_70143_R = 0.0f;
            this.func_70052_a(7, false);
        }
        this.func_71000_j(this.field_70165_t - d0, this.field_70163_u - d1, this.field_70161_v - d2);
        callbackInfo.cancel();
    }

    public void applyGravity() {
        if (!this.func_189652_ae() && !this.func_70051_ag()) {
            this.field_70181_x = this.field_70181_x <= 0.0 && Math.abs(this.field_70181_x - 0.005) >= 0.003 && Math.abs(this.field_70181_x - 0.005) < 0.003 ? -0.003 : (this.field_70181_x -= 0.005);
        }
    }

    private void updateLimbSwing() {
        double d7;
        this.field_184618_aE = this.field_70721_aZ;
        double d5 = this.field_70165_t - this.field_70169_q;
        double d9 = this instanceof EntityFlying ? this.field_70163_u - this.field_70167_r : 0.0;
        float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + (d7 = this.field_70161_v - this.field_70166_s) * d7)) * 4.0f;
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Shadow
    public abstract void func_71000_j(double var1, double var3, double var5);

    @Inject(method={"onLivingUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/world/World;isRemote:Z")}, cancellable=true, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;playShoulderEntityAmbientSound(Lnet/minecraft/nbt/NBTTagCompound;)V"))})
    public void onLivingUpdate(CallbackInfo callbackInfo) {
        float f = 0.0f;
        if (this.field_70122_E && !this.getShouldBeDead() && !this.isSwimming()) {
            f = Math.min(0.1f, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)));
        }
        this.field_71109_bG = this.field_71107_bF + (f - this.field_71107_bF) * 0.4f;
        this.field_70726_aT = 0.0f;
        if (!ConfigHandler.MiscellaneousConfig.sneakingForParrots) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && (this.func_70093_af() || this.func_70090_H())) {
            this.func_192030_dh();
        }
        callbackInfo.cancel();
    }

    @Inject(method={"addShoulderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void addShoulderEntity(NBTTagCompound p_192027_1_, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (ConfigHandler.MiscellaneousConfig.sneakingForParrots && this.func_70093_af()) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Shadow
    protected abstract void func_192030_dh();

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;setSize(FF)V"))
    public void setSizeTrySleep(EntityPlayer player, float width, float height) {
        this.setPose(Pose.SLEEPING);
    }

    private EntityPlayer getPlayer() {
        return (EntityPlayer)this;
    }
}

