/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.core.mixin;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.IBubbleColumnInteractable;
import com.fuzs.aquaacrobatics.entity.IRockableBoat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityBoat.class})
public abstract class EntityBoatMixin
extends Entity
implements IBubbleColumnInteractable,
IRockableBoat {
    private static final DataParameter<Integer> BOAT_ROCKING_TICKS = EntityDataManager.func_187226_a(EntityBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean aqua$rocking;
    private boolean aqua$rockingDownwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;

    public EntityBoatMixin(World worldIn) {
        super(worldIn);
    }

    @Override
    public void onEnterBubbleColumnWithAirAbove(boolean downwards) {
        if (!this.field_70170_p.field_72995_K) {
            this.aqua$rocking = true;
            this.aqua$rockingDownwards = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 0.7, this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    @Override
    public void aqua$doRegisterData() {
        this.field_70180_af.func_187214_a(BOAT_ROCKING_TICKS, (Object)0);
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityBoat;doBlockCollisions()V")})
    private void updateRocking(CallbackInfo ci) {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.aqua$rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    if (this.aqua$rockingDownwards) {
                        this.field_70181_x -= 0.7;
                        this.func_184226_ay();
                    } else {
                        this.field_70181_x = this.aqua$isPlayerRiding() ? 2.7 : 0.6;
                    }
                }
                this.aqua$rocking = false;
            }
        }
    }

    private boolean aqua$isPlayerRiding() {
        for (Entity entity : this.func_184188_bt()) {
            if (!EntityPlayer.class.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setRockingTicks(int p_203055_1_) {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return;
        }
        this.field_70180_af.func_187227_b(BOAT_ROCKING_TICKS, (Object)p_203055_1_);
    }

    public int getRockingTicks() {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return 0;
        }
        return (Integer)this.field_70180_af.func_187225_a(BOAT_ROCKING_TICKS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getRockingAngle(float partialTicks) {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return 0.0f;
        }
        return this.prevRockingAngle + (this.rockingAngle - this.prevRockingAngle) * partialTicks;
    }
}

