/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.immersion.stacks;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.utils.SpaceUtils;
import pl.asie.charset.module.immersion.stacks.StackShapes;

public class TileEntityStacks
extends TileBase {
    protected final ItemStack[] stacks = new ItemStack[64];

    public static boolean canAcceptStackType(ItemStack stack) {
        return StackShapes.isIngot(stack) || StackShapes.isFlatPlaced(stack);
    }

    private Vec3d getCenter(int i, ItemStack stack) {
        return SpaceUtils.getCenter((AxisAlignedBB)StackShapes.getIngotBox(i, stack));
    }

    protected boolean canPlace(int i, ItemStack stack) {
        if (this.stacks[i] != null) {
            return false;
        }
        ItemStack opponent = this.stacks[i ^ 1];
        if (opponent != null) {
            if (StackShapes.isIngot(opponent) && !StackShapes.isIngot(stack)) {
                return false;
            }
            if (StackShapes.isFlatPlaced(opponent) && !StackShapes.isFlatPlaced(stack)) {
                return false;
            }
        }
        if (StackShapes.isFlatPlaced(stack) && (i & 1) == 1 && this.stacks[i & 0xFFFFFFFE] == null) {
            return false;
        }
        if (i >= 8) {
            return this.stacks[i - 8] != null && this.stacks[(i ^ 1) - 8] != null;
        }
        TileEntity bottom = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (bottom instanceof TileEntityStacks) {
            return ((TileEntityStacks)bottom).stacks[i + 56] != null && ((TileEntityStacks)bottom).stacks[(i ^ 1) + 56] != null;
        }
        return this.field_145850_b.isSideSolid(this.field_174879_c.func_177977_b(), EnumFacing.UP, false);
    }

    protected boolean canRemove(int i) {
        if (this.stacks[i] == null) {
            return false;
        }
        if ((i & 1) == 0 && this.stacks[i | 1] != null && StackShapes.isFlatPlaced(this.stacks[i | 1])) {
            return false;
        }
        if (i < 56) {
            return this.stacks[i + 8] == null && this.stacks[(i ^ 1) + 8] == null;
        }
        TileEntity top = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (top instanceof TileEntityStacks) {
            return ((TileEntityStacks)top).stacks[i - 56] == null && ((TileEntityStacks)top).stacks[(i ^ 1) - 56] == null;
        }
        return true;
    }

    private void sort(IntList list, @Nullable Vec3d hitPos, @Nullable ItemStack stack) {
        if (hitPos != null) {
            Vec3d hitPosReal = hitPos.func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
            list.sort((a, b) -> {
                double aDist = hitPosReal.func_72436_e(this.getCenter((int)a, stack != null ? stack : this.stacks[a]));
                double bDist = hitPosReal.func_72436_e(this.getCenter((int)b, stack != null ? stack : this.stacks[b]));
                return Double.compare(aDist, bDist);
            });
        }
    }

    public boolean offerStack(boolean simulate, ItemStack stack, @Nullable Vec3d hitPos, boolean fillLayerFirst) {
        if (!TileEntityStacks.canAcceptStackType(stack) || stack.func_190916_E() != 1) {
            return false;
        }
        IntArrayList freePositions = new IntArrayList();
        int firstPos = -1;
        for (int i = 0; i < 64; ++i) {
            if (this.stacks[i] == null && this.canPlace(i, stack)) {
                freePositions.add(i);
                if (firstPos < 0) {
                    firstPos = i;
                }
            }
            if (fillLayerFirst && firstPos >= 0 && (i & 7) == 7) break;
        }
        if (freePositions.isEmpty()) {
            return false;
        }
        if (!simulate) {
            this.sort((IntList)freePositions, hitPos, stack);
            this.stacks[freePositions.getInt((int)0)] = stack;
            this.markChunkDirty();
            this.markBlockForUpdate();
        }
        return true;
    }

    public ItemStack removeStack(boolean simulate, @Nullable Vec3d hitPos) {
        IntArrayList remPositions = new IntArrayList();
        for (int i = 0; i < 64; ++i) {
            if (this.stacks[i] == null || !this.canRemove(i)) continue;
            remPositions.add(i);
        }
        if (remPositions.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        this.sort((IntList)remPositions, hitPos, null);
        if (simulate) {
            return this.stacks[remPositions.getInt(0)];
        }
        ItemStack stack = this.stacks[remPositions.getInt(0)];
        this.stacks[remPositions.getInt((int)0)] = null;
        this.markChunkDirty();
        this.markBlockForUpdate();
        return stack;
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        super.readNBTData(compound, isClient);
        int offset = 0;
        for (int i = 0; i < 32; ++i) {
            this.stacks[i * 2] = null;
            this.stacks[i * 2 + 1] = null;
            if (compound.func_150297_b("s" + i, 10)) {
                NBTTagCompound cpd = compound.func_74775_l("s" + i);
                if (cpd.func_150297_b("a", 10)) {
                    this.stacks[offset] = new ItemStack(cpd.func_74775_l("a"));
                    if (this.stacks[offset].func_190926_b()) {
                        this.stacks[offset] = null;
                    }
                }
                ++offset;
                if (cpd.func_150297_b("b", 10)) {
                    this.stacks[offset] = new ItemStack(cpd.func_74775_l("b"));
                    if (this.stacks[offset].func_190926_b()) {
                        this.stacks[offset] = null;
                    }
                }
                ++offset;
                continue;
            }
            offset += 2;
        }
        if (isClient) {
            this.markBlockForRenderUpdate();
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound = super.writeNBTData(compound, isClient);
        for (int i = 0; i < 64; i += 2) {
            boolean write = false;
            NBTTagCompound cpd1 = new NBTTagCompound();
            if (this.stacks[i] != null) {
                write = true;
                this.stacks[i].func_77955_b(cpd1);
            }
            NBTTagCompound cpd2 = new NBTTagCompound();
            if (this.stacks[i + 1] != null) {
                write = true;
                this.stacks[i + 1].func_77955_b(cpd2);
            }
            if (!write) continue;
            NBTTagCompound cpd = new NBTTagCompound();
            if (!cpd1.func_82582_d()) {
                cpd.func_74782_a("a", (NBTBase)cpd1);
            }
            if (!cpd2.func_82582_d()) {
                cpd.func_74782_a("b", (NBTBase)cpd2);
            }
            compound.func_74782_a("s" + (i >> 1), (NBTBase)cpd);
        }
        return compound;
    }

    public ItemStack getPickedBlock(@Nullable EntityPlayer player, @Nullable RayTraceResult result, IBlockState state) {
        if (result != null && result.subHit >= 0 && result.subHit < 64) {
            return this.stacks[result.subHit] != null ? this.stacks[result.subHit] : ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public boolean isFull() {
        for (int i = 0; i < 64; ++i) {
            if (this.stacks[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 64; ++i) {
            if (this.stacks[i] == null) continue;
            return false;
        }
        return true;
    }
}

