/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.immersion.stacks;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.MethodHandleHelper;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.SoundUtils;
import pl.asie.charset.module.immersion.stacks.BlockStacks;
import pl.asie.charset.module.immersion.stacks.RenderTileEntityStacks;
import pl.asie.charset.module.immersion.stacks.TileEntityStacks;

@CharsetModule(name="immersion.stacks", description="Place things! In the world! And they stack!", profile=ModuleProfile.FORCED)
public class CharsetImmersionStacks {
    public BlockStacks blockStacks;
    @CharsetModule.Configuration
    public static Configuration config;
    public static boolean insertToPlayerInventory;
    private static final Map<Class, Boolean> overridesOnBlockActivated;

    @Mod.EventHandler
    public void reloadReentrantConfig(CharsetLoadConfigEvent event) {
        insertToPlayerInventory = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"insertToPlayerInventory", (boolean)true, (String)"Should left-clicked items be inserted to the player inventory automatically, if possible?", (boolean)false);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this.blockStacks = new BlockStacks();
    }

    @SubscribeEvent
    public void registerBlock(RegistryEvent.Register<Block> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)this.blockStacks, (String)"stacks_decorative");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(TileEntityStacks.class, (String)"stacks_decorative");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:stacks_decorative", "normal"), (Object)new RenderTileEntityStacks());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseItem() == Event.Result.DENY) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b()) {
            TileEntity tile;
            boolean sneaking;
            if (!TileEntityStacks.canAcceptStackType(stack)) {
                return;
            }
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            BlockPos pos = event.getPos();
            Boolean overridesOBA = overridesOnBlockActivated.computeIfAbsent(state.func_177230_c().getClass(), c -> {
                try {
                    Method m = MethodHandleHelper.reflectMethodRecurse((Class)c, (boolean)true, (String)"onBlockActivated", (String)"func_180639_a", (Class[])new Class[]{World.class, BlockPos.class, IBlockState.class, EntityPlayer.class, EnumHand.class, EnumFacing.class, Float.TYPE, Float.TYPE, Float.TYPE});
                    return m.getDeclaringClass() != Block.class;
                }
                catch (Exception e) {
                    ModCharset.logger.warn("Exception during recursive method check on " + c + "!");
                    e.printStackTrace();
                    return true;
                }
            });
            boolean fullStack = sneaking = event.getEntityPlayer().func_70093_af();
            if (overridesOBA.booleanValue()) {
                if (fullStack) {
                    fullStack = false;
                } else {
                    return;
                }
            }
            if (!(state.func_177230_c() instanceof BlockStacks) && !state.func_177230_c().func_176200_f((IBlockAccess)event.getWorld(), event.getPos()) && event.getFace() != null) {
                if (!sneaking && event.getFace() != EnumFacing.UP) {
                    return;
                }
                pos = pos.func_177972_a(event.getFace());
            }
            while ((state = event.getWorld().func_180495_p(pos)).func_177230_c() instanceof BlockStacks) {
                tile = event.getWorld().func_175625_s(pos);
                if (!(tile instanceof TileEntityStacks)) continue;
                if (!((TileEntityStacks)tile).isFull()) break;
                pos = pos.func_177984_a();
            }
            if (state.func_177230_c().func_176200_f((IBlockAccess)event.getWorld(), pos)) {
                state = this.blockStacks.func_176223_P();
                event.getWorld().func_175656_a(pos, state);
            }
            if (state.func_177230_c() instanceof BlockStacks && (tile = event.getWorld().func_175625_s(pos)) instanceof TileEntityStacks) {
                int count = stack.func_190916_E();
                for (int i = 0; i < (fullStack ? count : 1) && !stack.func_190926_b(); ++i) {
                    ItemStack stackOffered = stack.func_77946_l();
                    stackOffered.func_190920_e(1);
                    if (!((TileEntityStacks)tile).offerStack(false, stackOffered, event.getHitVec(), fullStack)) continue;
                    SoundUtils.playSoundRemote((EntityPlayer)event.getEntityPlayer(), (Vec3d)event.getHitVec(), (double)64.0, (SoundEvent)SoundEvents.field_187772_dn, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f, (float)1.0f);
                    if (!event.getEntityPlayer().func_184812_l_()) {
                        stack.func_190918_g(stackOffered.func_190916_E());
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                }
                if (((TileEntityStacks)tile).isEmpty()) {
                    event.getWorld().func_175698_g(pos);
                }
            }
        }
    }

    static {
        overridesOnBlockActivated = new HashMap<Class, Boolean>();
    }
}

