/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui.tooltip;

import icbm.classic.lib.transform.region.Rectangle;
import icbm.classic.prefab.gui.GuiContainerBase;
import icbm.classic.prefab.gui.IGuiComponent;
import icbm.classic.prefab.gui.tooltip.IToolTip;
import lombok.Generated;
import net.minecraft.util.text.ITextComponent;

public abstract class TooltipBase
implements IToolTip,
IGuiComponent {
    private final Rectangle bounds;
    private float hoverDelay;
    private GuiContainerBase container;
    private boolean isHovering = false;
    private float hoveringTicks = 0.0f;

    public TooltipBase(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, x + width, y + height);
    }

    public TooltipBase withDelay(float delay) {
        this.hoverDelay = delay;
        return this;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.isHovering = this.isWithin(mouseX, mouseY);
        this.hoveringTicks = this.isHovering ? (this.hoveringTicks += partialTicks) : 0.0f;
    }

    @Override
    public void onAddedToHost(GuiContainerBase container) {
        this.container = container;
    }

    @Override
    public boolean isWithin(int x, int y) {
        return this.bounds.isWithin(x - this.container.getGuiLeft(), y - this.container.getGuiTop());
    }

    @Override
    public final ITextComponent getTooltip() {
        if (this.hoveringTicks < this.hoverDelay) {
            return null;
        }
        return this.getActualTooltip();
    }

    protected abstract ITextComponent getActualTooltip();

    @Generated
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Generated
    public float getHoverDelay() {
        return this.hoverDelay;
    }

    @Generated
    public boolean isHovering() {
        return this.isHovering;
    }
}

