/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.mods.jei;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.projectile.IProjectileStack;
import icbm.classic.config.ConfigJEI;
import icbm.classic.content.cargo.CargoHolderHandler;
import icbm.classic.content.cargo.CargoProjectileData;
import icbm.classic.content.cluster.missile.CapabilityClusterMissileStack;
import icbm.classic.content.cluster.missile.ClusterMissileHandler;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.projectile.ProjectileStack;
import icbm.classic.mods.jei.CargoItemWrapper;
import icbm.classic.mods.jei.ClusterItemWrapper;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class JEIProxy
implements IModPlugin {
    private String cargoItemKey(ISubtypeRegistry subtypeRegistry, ItemStack itemStack) {
        ItemStack stack;
        IProjectileStack projectileStack;
        String key = Integer.toString(itemStack.func_77960_j());
        if (itemStack.hasCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null) && (projectileStack = (IProjectileStack)itemStack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null)) instanceof ProjectileStack && projectileStack.getProjectileData() instanceof CargoProjectileData && (stack = ((CargoProjectileData)projectileStack.getProjectileData()).getHeldItem()) != null && !stack.func_190926_b()) {
            return key + ":" + stack.func_77973_b().getRegistryName() + ":" + Optional.ofNullable(subtypeRegistry.getSubtypeInfo(stack)).orElse(Integer.toString(stack.func_77960_j()));
        }
        return key;
    }

    private String clusterItemKey(ISubtypeRegistry subtypeRegistry, ItemStack itemStack) {
        ItemStack stack;
        ICapabilityMissileStack projectileStack;
        String key = Integer.toString(itemStack.func_77960_j());
        if (itemStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) && (projectileStack = (ICapabilityMissileStack)itemStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) instanceof CapabilityClusterMissileStack && (stack = (ItemStack)((CapabilityClusterMissileStack)projectileStack).getActionDataCluster().getClusterSpawnEntries().stream().findFirst().orElse(null)) != null && !stack.func_190926_b()) {
            return key + ":" + stack.func_77973_b().getRegistryName() + ":" + Optional.ofNullable(subtypeRegistry.getSubtypeInfo(stack)).orElse(Integer.toString(stack.func_77960_j()));
        }
        return key;
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        if (!ConfigJEI.DISABLED) {
            subtypeRegistry.registerSubtypeInterpreter((Item)ItemReg.itemParachute, i -> this.cargoItemKey(subtypeRegistry, i));
            subtypeRegistry.registerSubtypeInterpreter((Item)ItemReg.itemBalloon, i -> this.cargoItemKey(subtypeRegistry, i));
            subtypeRegistry.registerSubtypeInterpreter(ItemReg.itemClusterMissile, i -> this.clusterItemKey(subtypeRegistry, i));
        }
    }

    public void register(IModRegistry registry) {
        if (!ConfigJEI.DISABLED && !ConfigJEI.DISABLE_PAYLOAD) {
            ArrayList<Object> recipes = new ArrayList<Object>();
            for (ItemStack stack : registry.getIngredientRegistry().getIngredients(ItemStack.class)) {
                if (CargoHolderHandler.isAllowed(stack)) {
                    recipes.add(new CargoItemWrapper(new ItemStack((Item)ItemReg.itemBalloon), stack, new ResourceLocation("icbmclassic", "balloon_cargo")));
                    recipes.add(new CargoItemWrapper(new ItemStack((Item)ItemReg.itemParachute), stack, new ResourceLocation("icbmclassic", "parachute_cargo")));
                }
                if (!ClusterMissileHandler.isAllowed(stack)) continue;
                recipes.add(new ClusterItemWrapper(new ItemStack(ItemReg.itemClusterMissile), stack, new ResourceLocation("icbmclassic", "cluster_missile")));
            }
            registry.addRecipes(recipes, "minecraft.crafting");
        }
    }
}

