/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.lib.tracker.EventTrackerEntry;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;

public class EventTrackerHelpers {
    public static final ResourceLocation TILE_POS = new ResourceLocation("icbmclassic", "tile.pos");
    public static final ResourceLocation TILE_POS_X = new ResourceLocation("icbmclassic", "tile.pos.x");
    public static final ResourceLocation TILE_POS_Y = new ResourceLocation("icbmclassic", "tile.pos.y");
    public static final ResourceLocation TILE_POS_Z = new ResourceLocation("icbmclassic", "tile.pos.z");
    public static final ResourceLocation WORLD_ID = new ResourceLocation("icbmclassic", "level.id");
    public static final ResourceLocation WORLD_NAME = new ResourceLocation("icbmclassic", "level.name");
    public static final ResourceLocation WORLD_SIDE = new ResourceLocation("icbmclassic", "level.side");
    public static String SIDE_CLIENT = "client";
    public static String SIDE_SERVER = "server";

    public static Function<EventTrackerEntry, String> stringAt(int index) {
        return entry -> (String)entry.getData()[index];
    }

    public static Function<EventTrackerEntry, Integer> intAt(int index) {
        return entry -> (Integer)entry.getData()[index];
    }

    public static Integer getWorldId(World world) {
        return Optional.ofNullable(world).map(w -> w.field_73011_w).map(WorldProvider::getDimension).orElse(null);
    }

    public static String getWorldName(World world) {
        return Optional.ofNullable(world).map(World::func_72912_H).map(WorldInfo::func_76065_j).orElse(null);
    }

    public static String getSide(World world) {
        return Optional.ofNullable(world).map(w -> w.field_72995_K ? SIDE_CLIENT : SIDE_SERVER).orElse(null);
    }
}

