/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio.messages;

import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.radio.messages.IIncomingMissileMessage;
import icbm.classic.content.blocks.launcher.status.LaunchedWithMissile;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public class IncomingMissileMessage
implements IIncomingMissileMessage {
    private final String channel;
    private final IMissile missile;
    private final boolean trigger;

    @Override
    public Vec3d getIntercept(double x, double y, double z, double velocity) {
        if (this.missile != null && this.missile.getMissileEntity() != null) {
            Entity entity = this.missile.getMissileEntity();
            int maxTime = 20;
            for (int time = 1; time <= 20; ++time) {
                double tX = entity.field_70165_t + entity.field_70159_w * (double)time;
                double tY = entity.field_70163_u + entity.field_70181_x * (double)time;
                double tZ = entity.field_70161_v + entity.field_70179_y * (double)time;
                double mag = Math.sqrt(tX * tX + tY * tY + tZ * tZ);
                if (!(mag < velocity * (double)time) && time != 20) continue;
                return this.missile.getVec3d();
            }
            return this.missile.getVec3d();
        }
        return null;
    }

    @Override
    public Vec3d getTarget() {
        if (this.missile != null) {
            return this.missile.getVec3d();
        }
        return null;
    }

    @Override
    public boolean shouldTrigger() {
        return this.trigger;
    }

    @Override
    public void onTriggerCallback(IActionStatus status) {
        IMissile firedMissile;
        if (status instanceof LaunchedWithMissile && (firedMissile = ((LaunchedWithMissile)status).getMissile()) != null && firedMissile.getMissileEntity() instanceof EntitySurfaceToAirMissile) {
            EntitySurfaceToAirMissile sam = (EntitySurfaceToAirMissile)firedMissile.getMissileEntity();
            sam.scanLogic.setCurrentTarget(this.missile.getMissileEntity());
        }
    }

    @Generated
    public IncomingMissileMessage(String channel, IMissile missile, boolean trigger) {
        this.channel = channel;
        this.missile = missile;
        this.trigger = trigger;
    }

    @Override
    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Override
    @Generated
    public IMissile getMissile() {
        return this.missile;
    }

    @Generated
    public boolean isTrigger() {
        return this.trigger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncomingMissileMessage)) {
            return false;
        }
        IncomingMissileMessage other = (IncomingMissileMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTrigger() != other.isTrigger()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        IMissile this$missile = this.getMissile();
        IMissile other$missile = other.getMissile();
        return !(this$missile == null ? other$missile != null : !this$missile.equals(other$missile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IncomingMissileMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrigger() ? 79 : 97);
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        IMissile $missile = this.getMissile();
        result = result * 59 + ($missile == null ? 43 : $missile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IncomingMissileMessage(channel=" + this.getChannel() + ", missile=" + this.getMissile() + ", trigger=" + this.isTrigger() + ")";
    }
}

