/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import icbm.classic.api.EnumTier;
import icbm.classic.api.actions.IAction;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.explosion.IBlastFactory;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.lib.actions.ActionDataBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ExplosiveData
extends ActionDataBase
implements IExplosiveData {
    @Nonnull
    public final ResourceLocation regName;
    @Deprecated
    private final int id;
    @Nonnull
    private final EnumTier tier;
    @Nonnull
    private final IBlastFactory blastCreationFactory;

    @Override
    public ResourceLocation getRegistryKey() {
        return this.regName;
    }

    @Override
    public int getRegistryID() {
        return this.id;
    }

    @Override
    @Nonnull
    public IAction create(World world, double x, double y, double z, @Nonnull IActionSource source, @Nullable IActionFieldProvider fieldAccessors) {
        IAction blast = this.blastCreationFactory.create(world, x, y, z, source);
        if (blast instanceof IBlastInit) {
            ((IBlastInit)blast).setExplosiveData(this);
            ((IBlastInit)blast).setActionSource(source);
            if (fieldAccessors != null && fieldAccessors.hasField(ActionFields.AREA_SIZE)) {
                ((IBlastInit)blast).setBlastSize(fieldAccessors.getValue(ActionFields.AREA_SIZE).floatValue());
            }
        }
        blast.applyFields(fieldAccessors);
        blast.applyFields(this);
        return blast;
    }

    public boolean equals(Object object) {
        if (object instanceof ExplosiveData) {
            return ((ExplosiveData)object).id == this.id;
        }
        return false;
    }

    @Override
    public int compareTo(IExplosiveData o) {
        return Integer.compare(this.getRegistryID(), o.getRegistryID());
    }

    @Generated
    public String toString() {
        return "ExplosiveData(regName=" + this.getRegName() + ", id=" + this.getId() + ")";
    }

    @Generated
    public ExplosiveData(@Nonnull ResourceLocation regName, int id, @Nonnull EnumTier tier, @Nonnull IBlastFactory blastCreationFactory) {
        if (regName == null) {
            throw new NullPointerException("regName is marked non-null but is null");
        }
        if (tier == null) {
            throw new NullPointerException("tier is marked non-null but is null");
        }
        if (blastCreationFactory == null) {
            throw new NullPointerException("blastCreationFactory is marked non-null but is null");
        }
        this.regName = regName;
        this.id = id;
        this.tier = tier;
        this.blastCreationFactory = blastCreationFactory;
    }

    @Nonnull
    @Generated
    public ResourceLocation getRegName() {
        return this.regName;
    }

    @Deprecated
    @Generated
    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    @Generated
    public EnumTier getTier() {
        return this.tier;
    }

    @Nonnull
    @Generated
    public IBlastFactory getBlastCreationFactory() {
        return this.blastCreationFactory;
    }
}

