/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.radioactive;

import com.google.common.collect.Lists;
import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigMain;
import icbm.classic.content.gas.ProtectiveArmorHandler;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRadioactive
extends Block {
    public static final PropertyType TYPE_PROP = new PropertyType();
    public static final DamageSource damageSource = new DamageSource("icbmclassic:radioactive_block");
    public float decayChance = 0.85f;
    public int areaOfEffect = 5;
    public int tickRate = 5;
    public float damage = 2.0f;

    public BlockRadioactive() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.STONE)));
        this.setRegistryName("icbmclassic:radioactive");
        this.func_149663_c("icbmclassic:radioactive");
        this.func_149647_a(ICBMClassic.CREATIVE_TAB);
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
    }

    public int func_149738_a(World worldIn) {
        return this.tickRate;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!worldIn.field_72995_K) {
            AxisAlignedBB bounds = new AxisAlignedBB(pos).func_72314_b((double)this.areaOfEffect, (double)this.areaOfEffect, (double)this.areaOfEffect);
            List entities = worldIn.func_72872_a(EntityLivingBase.class, bounds);
            for (EntityLivingBase entity : entities) {
                float protection;
                if (!(random.nextFloat() < this.decayChance) || !((protection = ProtectiveArmorHandler.getProtectionRating(entity)) < ConfigMain.protectiveArmor.minProtectionRadiation) && !(protection < random.nextFloat())) continue;
                entity.func_70097_a(damageSource, this.damage);
                entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20));
            }
            worldIn.func_175684_a(pos, (Block)this, Math.max(1, random.nextInt(this.tickRate)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(12) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 1.7f + 0.3f, false);
        }
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (blockState.func_177228_b().containsKey((Object)TYPE_PROP)) {
            EnumType type = (EnumType)((Object)blockState.func_177228_b().get((Object)TYPE_PROP));
            switch (type) {
                case DIRT: {
                    return Blocks.field_150346_d.func_176195_g(Blocks.field_150346_d.func_176223_P(), worldIn, pos);
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176195_g(Blocks.field_150348_b.func_176223_P(), worldIn, pos);
                }
            }
        }
        return this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177228_b().containsKey((Object)TYPE_PROP)) {
            EnumType type = (EnumType)((Object)blockState.func_177228_b().get((Object)TYPE_PROP));
            switch (type) {
                case DIRT: {
                    return Blocks.field_150346_d.getExplosionResistance(world, pos, exploder, explosion);
                }
                case STONE: {
                    return Blocks.field_150348_b.getExplosionResistance(world, pos, exploder, explosion);
                }
            }
        }
        return this.func_149638_a(exploder);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_PROP});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)TYPE_PROP))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE_PROP, (Comparable)((Object)EnumType.get(meta)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J()) {
            for (EnumType type : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        DIRT,
        STONE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static EnumType get(int meta) {
            return meta >= 0 && meta < EnumType.values().length ? EnumType.values()[meta] : STONE;
        }
    }

    public static class PropertyType
    extends PropertyEnum<EnumType> {
        public PropertyType() {
            super("type", EnumType.class, (Collection)Lists.newArrayList((Object[])EnumType.values()));
        }
    }
}

