/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.source.cause;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.cause.ICausedByBlock;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.content.missile.logic.source.cause.ActionCause;
import icbm.classic.lib.saving.NbtSaveHandler;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class CausedByBlock
extends ActionCause
implements ICausedByBlock {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "block");
    private World world;
    private BlockPos blockPos;
    private IBlockState blockState;
    private int worldId;
    private static final NbtSaveHandler<CausedByBlock> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("level", CausedByBlock::getWorldId, CausedByBlock::setWorldId).nodeBlockPos("pos", CausedByBlock::getBlockPos, CausedByBlock::setBlockPos).nodeBlockState("state", CausedByBlock::getBlockState, CausedByBlock::setBlockState).base();

    public CausedByBlock(World world, BlockPos pos, IBlockState state) {
        this.world = world;
        this.worldId = world.field_73011_w.getDimension();
        this.blockPos = pos;
        this.blockState = state;
    }

    @Override
    public World getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.worldId);
        }
        return this.world;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    @Nonnull
    public IBuilderRegistry<IActionCause> getRegistry() {
        return ICBMClassicAPI.ACTION_CAUSE_REGISTRY;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    @Generated
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    @Generated
    public IBlockState getBlockState() {
        return this.blockState;
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public void setWorld(World world) {
        this.world = world;
    }

    @Generated
    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    @Generated
    public void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
    }

    @Generated
    public void setWorldId(int worldId) {
        this.worldId = worldId;
    }

    @Generated
    public String toString() {
        return "CausedByBlock(world=" + this.getWorld() + ", blockPos=" + this.getBlockPos() + ", blockState=" + this.getBlockState() + ", worldId=" + this.getWorldId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CausedByBlock)) {
            return false;
        }
        CausedByBlock other = (CausedByBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getWorldId() != other.getWorldId()) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$blockPos = this.getBlockPos();
        BlockPos other$blockPos = other.getBlockPos();
        if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
            return false;
        }
        IBlockState this$blockState = this.getBlockState();
        IBlockState other$blockState = other.getBlockState();
        return !(this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CausedByBlock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getWorldId();
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        BlockPos $blockPos = this.getBlockPos();
        result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
        IBlockState $blockState = this.getBlockState();
        result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
        return result;
    }

    @Generated
    public CausedByBlock() {
    }
}

