/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class FollowTargetLogic
extends DeadFlightLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "direct.follow");

    public FollowTargetLogic() {
    }

    public FollowTargetLogic(int fuel) {
        super(fuel);
    }

    @Override
    public float engineSmokeRed(Entity entity) {
        return 1.0f;
    }

    @Override
    public float engineSmokeGreen(Entity entity) {
        return 0.5f;
    }

    @Override
    public float engineSmokeBlue(Entity entity) {
        return 0.5f;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (!entity.field_70170_p.field_72995_K && this.hasFuel(entity) && missile.getTargetData() != null) {
            double motionX = missile.getTargetData().getX() - entity.field_70165_t;
            double motionY = missile.getTargetData().getY() - entity.field_70163_u;
            double motionZ = missile.getTargetData().getZ() - entity.field_70161_v;
            float velocity = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            entity.field_70159_w = (motionX /= (double)velocity) * (double)ConfigMissile.SAM_MISSILE.FLIGHT_SPEED;
            entity.field_70181_x = (motionY /= (double)velocity) * (double)ConfigMissile.SAM_MISSILE.FLIGHT_SPEED;
            entity.field_70179_y = (motionZ /= (double)velocity) * (double)ConfigMissile.SAM_MISSILE.FLIGHT_SPEED;
            float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            entity.field_70126_B = entity.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            entity.field_70127_C = entity.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
        }
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }
}

