/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.bomblet;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.lib.capability.ex.CapabilityExplosiveEntity;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBombDroplet
extends EntityProjectile<EntityBombDroplet>
implements IEntityAdditionalSpawnData {
    public static final DamageSource DAMAGE_SOURCE = new DamageSource("icbmclassic:bomblet");
    public final CapabilityExplosiveEntity explosive = new CapabilityExplosiveEntity(this);
    private static final NbtSaveHandler<EntityBombDroplet> SAVE_LOGIC = new NbtSaveHandler().mainRoot().node(new NbtSaveNode<EntityBombDroplet, NBTTagCompound>("explosive", missile -> missile.explosive.serializeNBT(), (missile, data) -> missile.explosive.deserializeNBT((NBTTagCompound)data))).base();

    public EntityBombDroplet(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.hasHealth = false;
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        return MathHelper.func_76123_f((float)(velocity * ConfigMissile.bomblet.impactDamage));
    }

    @Override
    protected DamageSource getImpactDamageSource(Entity entityHit, float velocity, RayTraceResult hit) {
        return DAMAGE_SOURCE;
    }

    @Override
    protected void onImpact(RayTraceResult hit) {
        super.onImpact(hit);
        this.explosive.doExplosion(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, new ActionSource(this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new EntityCause(this)));
    }

    public Vec3d func_70676_i(float partialTicks) {
        double mag = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        return new Vec3d(this.field_70159_w / mag, this.field_70181_x / mag, this.field_70179_y / mag);
    }

    @Override
    protected boolean shouldCollideWith(Entity entity) {
        return super.shouldCollideWith(entity) && !(entity instanceof EntityBombDroplet);
    }

    @Override
    public float getMaxHealth() {
        return Math.max(1, ConfigMissile.bomblet.health);
    }

    @Override
    protected void onDestroyedBy(DamageSource source, float damage) {
        super.onDestroyedBy(source, damage);
        if (source.func_94541_c() || source.func_76347_k()) {
            this.explosive.doExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, new ActionSource(this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new EntityCause(this)));
        }
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)ICBMClassicAPI.EXPLOSIVE_CAPABILITY.cast((Object)this.explosive);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY || super.hasCapability(capability, facing);
    }

    public String func_70005_c_() {
        IExplosiveData data = this.explosive.getExplosiveData();
        if (data != null) {
            return I18n.func_74838_a((String)("bomb.droplet." + data.getRegistryKey().toString() + ".name"));
        }
        return I18n.func_74838_a((String)"bomb.droplet.icbmclassic:generic.name");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBombDroplet.func_184183_bd()) * d0;
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        super.writeSpawnData(additionalMissileData);
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        super.readSpawnData(additionalMissileData);
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }

    public ItemStack toStack() {
        return this.explosive.toStack();
    }
}

