/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cargo;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.missiles.projectile.IProjectileStack;
import icbm.classic.api.missiles.projectile.IProjectileThrowable;
import icbm.classic.api.missiles.projectile.ProjectileTypes;
import icbm.classic.content.cargo.ProjectileCargoMode;
import icbm.classic.content.cargo.balloon.BalloonProjectileData;
import icbm.classic.content.cargo.parachute.ParachuteProjectileData;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.projectile.ProjectileStack;
import icbm.classic.prefab.item.ItemBase;
import icbm.classic.prefab.item.ItemStackCapProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemThrowableProjectile
extends ItemBase {
    public static final int MAX_USE_DURATION = 60;
    public static final float THROW_VELOCITY = 0.5f;
    public static final TextComponentTranslation ERROR_THROWING_INTERFACE = new TextComponentTranslation("error.icbmclassic:projectile.throwing.interface", new Object[]{IProjectileThrowable.class.getSimpleName()});
    public static final TextComponentTranslation ERROR_THROWING_TYPE = new TextComponentTranslation("error.icbmclassic:projectile.throwing.type", new Object[]{ProjectileTypes.TYPE_THROWABLE.getKey()});

    public ItemThrowableProjectile() {
        this.func_77625_d(16);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        ItemStackCapProvider provider = new ItemStackCapProvider(stack);
        provider.add("projectile", ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, new ProjectileStack());
        return provider;
    }

    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 60;
    }

    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entityLiving, int timeLeft) {
        if (!world.field_72995_K && ItemThrowableProjectile.throwProjectile(stack, world, (Entity)entityLiving) && !(entityLiving instanceof EntityPlayer) || !((EntityPlayer)entityLiving).func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    public static boolean throwProjectile(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity thrower) {
        EnumHand hand;
        boolean isCreative = thrower instanceof EntityPlayer && ((EntityPlayer)thrower).func_184812_l_();
        EnumHand enumHand = hand = thrower instanceof EntityLivingBase ? ((EntityLivingBase)thrower).func_184600_cs() : EnumHand.MAIN_HAND;
        if (!stack.hasCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null)) {
            return false;
        }
        IProjectileStack projectileStack = (IProjectileStack)stack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null);
        if (projectileStack == null) {
            return false;
        }
        IProjectileData projectileData = projectileStack.getProjectileData();
        if (projectileData == null) {
            return false;
        }
        Object parachute = projectileData.newEntity(world, !isCreative);
        if (!projectileData.isType(ProjectileTypes.TYPE_THROWABLE)) {
            if (thrower instanceof EntityPlayer) {
                ((EntityPlayer)thrower).func_146105_b((ITextComponent)ERROR_THROWING_TYPE, true);
            }
            ICBMClassic.logger().warn("ItemParachute: Couldn't throw projectile as type(s) isn't supported. This is likely missing implementation on the projectile. Stack: {}, Data: {}, Entity: {}", (Object)projectileStack, projectileData, (Object)thrower);
            return false;
        }
        if (!(parachute instanceof IProjectileThrowable)) {
            if (thrower instanceof EntityPlayer) {
                ((EntityPlayer)thrower).func_146105_b((ITextComponent)ERROR_THROWING_INTERFACE, true);
            }
            ICBMClassic.logger().warn("ItemParachute: Couldn't throw projectile as it doesn't support IProjectileThrowable.Stack: {}, Data: {}, Entity: {}", (Object)projectileStack, projectileData, (Object)thrower);
            return false;
        }
        float yaw = thrower instanceof EntityLivingBase ? ((EntityLivingBase)thrower).field_70759_as : thrower.field_70177_z;
        float pitch = thrower.field_70125_A;
        double x = thrower.field_70165_t;
        double y = thrower.field_70163_u + (double)thrower.func_70047_e();
        double z = thrower.field_70161_v;
        ActionSource source = new ActionSource(world, new Vec3d(x, y, z), new EntityCause(thrower));
        ((IProjectileThrowable)parachute).throwProjectile(parachute, source, x, y, z, yaw, pitch, 0.5f, 0.0f);
        if (world.func_72838_d(parachute)) {
            projectileStack.getProjectileData().onEntitySpawned(parachute, thrower, hand);
            return true;
        }
        return false;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        IProjectileStack projectileStack = (IProjectileStack)stack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null);
        if (projectileStack == null || projectileStack.getProjectileData() == null) {
            String key = this.func_77667_c(stack) + ".info";
            float gravity = -0.19999999f;
            float air = 5.000001f;
            LanguageUtility.outputLines((ITextComponent)new TextComponentTranslation(key, new Object[]{String.format("%.2f", Float.valueOf(5.000001f)) + " %", String.format("%.2f", Float.valueOf(-0.19999999f))}), list::add);
        }
        if (projectileStack != null && projectileStack.getProjectileData() != null) {
            LanguageUtility.outputLines(projectileStack.getProjectileData().getTooltip(), list::add);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            if (this == ItemReg.itemParachute) {
                items.add((Object)this.parachuteWith(new ParachuteProjectileData().setHeldItem(new ItemStack(Items.field_151110_aK)).setParachuteMode(ProjectileCargoMode.ITEM)));
                items.add((Object)this.parachuteWith(new ParachuteProjectileData().setHeldItem(new ItemStack(Blocks.field_150460_al)).setParachuteMode(ProjectileCargoMode.BLOCK)));
                items.add((Object)this.parachuteWith(new ParachuteProjectileData().setHeldItem(new ItemStack(Blocks.field_150335_W)).setParachuteMode(ProjectileCargoMode.BLOCK)));
            } else if (this == ItemReg.itemBalloon) {
                items.add((Object)this.parachuteWith(new BalloonProjectileData().setHeldItem(new ItemStack(Items.field_151110_aK)).setParachuteMode(ProjectileCargoMode.ITEM)));
            }
        }
    }

    private ItemStack parachuteWith(IProjectileData data) {
        ItemStack stack = new ItemStack((Item)this);
        IProjectileStack projectileStack = (IProjectileStack)stack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null);
        if (projectileStack instanceof ProjectileStack) {
            ((ProjectileStack)projectileStack).setProjectileData(data);
        }
        return stack;
    }
}

