/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks;

import com.google.common.collect.Lists;
import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigMain;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpikes
extends Block {
    public static final SpikeProperty SPIKE_PROPERTY = new SpikeProperty();
    public static final DamageSource DAMAGE_SOURCE = new DamageSource("icbmclassic:spikes");

    public BlockSpikes() {
        super(Material.field_151573_f);
        this.setRegistryName("icbmclassic:spikes");
        this.func_149663_c("icbmclassic:spikes");
        this.func_149647_a(ICBMClassic.CREATIVE_TAB);
        this.func_149711_c(1.0f);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SPIKE_PROPERTY});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)SPIKE_PROPERTY, (Comparable)((Object)EnumSpikes.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSpikes)((Object)state.func_177229_b((IProperty)SPIKE_PROPERTY))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SPIKE_PROPERTY, (Comparable)((Object)EnumSpikes.get(meta)));
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (world.func_180495_p(pos).func_177229_b((IProperty)SPIKE_PROPERTY) == EnumSpikes.POISON) {
                entity.func_70097_a(DAMAGE_SOURCE, ConfigMain.spikes.poisonDamage);
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 140, 0));
            } else if (world.func_180495_p(pos).func_177229_b((IProperty)SPIKE_PROPERTY) == EnumSpikes.FIRE) {
                entity.func_70097_a(DAMAGE_SOURCE, ConfigMain.spikes.fireDamage);
                entity.func_70015_d(7);
            } else {
                entity.func_70097_a(DAMAGE_SOURCE, ConfigMain.spikes.normalDamage);
            }
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J()) {
            for (EnumSpikes spikes : EnumSpikes.values()) {
                items.add((Object)new ItemStack((Block)this, 1, spikes.ordinal()));
            }
        }
    }

    public static enum EnumSpikes implements IStringSerializable
    {
        NORMAL,
        POISON,
        FIRE;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static EnumSpikes get(int meta) {
            return meta >= 0 && meta < EnumSpikes.values().length ? EnumSpikes.values()[meta] : NORMAL;
        }
    }

    public static class SpikeProperty
    extends PropertyEnum<EnumSpikes> {
        protected SpikeProperty() {
            super("type", EnumSpikes.class, (Collection)Lists.newArrayList((Object[])EnumSpikes.values()));
        }
    }
}

