/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import com.google.common.collect.ImmutableList;
import icbm.classic.api.actions.data.ActionField;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.content.blast.BlastTNT;
import icbm.classic.content.missile.entity.EntityMissile;
import java.util.Collection;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;

public class BlastBreach
extends BlastTNT {
    public static final ImmutableList<ActionField> SUPPORTED_FIELDS = ImmutableList.of(ActionFields.HOST_DIRECTION);
    private int depth;
    private int width;
    private float energy;
    private float energyDistanceScale;
    private float energyCostDistance;
    private EnumFacing direction;

    @Override
    public <VALUE, TAG extends NBTBase> void setValue(ActionField<VALUE, TAG> key, VALUE value) {
        if (key == ActionFields.HOST_DIRECTION) {
            this.direction = ActionFields.HOST_DIRECTION.cast(value);
        }
    }

    @Override
    @Nonnull
    public Collection<ActionField> getFields() {
        return SUPPORTED_FIELDS;
    }

    @Override
    protected void calculateDamage() {
        if (this.depth <= 0) {
            super.calculateDamage();
        } else if (!this.world().field_72995_K) {
            if (this.direction == null) {
                if (this.field_77283_e != null) {
                    if (this.field_77283_e.field_70125_A > 45.0f) {
                        this.direction = this.field_77283_e instanceof EntityMissile ? EnumFacing.UP : EnumFacing.DOWN;
                    } else if (this.field_77283_e.field_70125_A < -45.0f) {
                        this.direction = this.field_77283_e instanceof EntityMissile ? EnumFacing.DOWN : EnumFacing.UP;
                    } else {
                        this.direction = this.field_77283_e.func_184172_bi();
                        if (this.direction == EnumFacing.EAST || this.direction == EnumFacing.WEST) {
                            this.direction = this.direction.func_176734_d();
                        }
                    }
                } else {
                    this.direction = EnumFacing.DOWN;
                }
            }
            for (int h = -this.width; h <= this.width; ++h) {
                block1: for (int w = -this.width; w <= this.width; ++w) {
                    float energyRemaining = this.energy - this.energy * (float)(h + w) * this.energyDistanceScale;
                    for (int depthIndex = 0; depthIndex < this.depth && energyRemaining > 0.0f; ++depthIndex) {
                        int x = this.xi() + this.direction.func_82601_c() * depthIndex;
                        int y = this.yi() + this.direction.func_96559_d() * depthIndex;
                        int z = this.zi() + this.direction.func_82599_e() * depthIndex;
                        if (this.direction == EnumFacing.DOWN || this.direction == EnumFacing.UP) {
                            x += h;
                            z += w;
                        } else if (this.direction == EnumFacing.EAST || this.direction == EnumFacing.WEST) {
                            y += h;
                            z += w;
                        } else if (this.direction == EnumFacing.NORTH || this.direction == EnumFacing.SOUTH) {
                            y += h;
                            x += w;
                        } else {
                            return;
                        }
                        BlockPos pos = new BlockPos(x, y, z);
                        IBlockState state = this.field_77287_j.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (!block.isAir(state, (IBlockAccess)this.world(), pos)) {
                            if (block.func_176195_g(state, this.field_77287_j, pos) < 0.0f) continue block1;
                            float cost = block.getExplosionResistance(this.world(), pos, this.field_77283_e, (Explosion)this);
                            if (!(cost < energyRemaining)) continue;
                            energyRemaining -= cost;
                            this.func_180343_e().add(pos);
                            continue;
                        }
                        energyRemaining *= 1.0f - this.energyCostDistance;
                    }
                }
            }
            this.world().func_184148_a(null, this.location.x(), this.location.y(), this.location.z(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 5.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Generated
    public BlastBreach setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    @Generated
    public BlastBreach setWidth(int width) {
        this.width = width;
        return this;
    }

    @Generated
    public BlastBreach setEnergy(float energy) {
        this.energy = energy;
        return this;
    }

    @Generated
    public BlastBreach setEnergyDistanceScale(float energyDistanceScale) {
        this.energyDistanceScale = energyDistanceScale;
        return this;
    }

    @Generated
    public BlastBreach setEnergyCostDistance(float energyCostDistance) {
        this.energyCostDistance = energyCostDistance;
        return this;
    }

    @Generated
    public BlastBreach setDirection(EnumFacing direction) {
        this.direction = direction;
        return this;
    }
}

