/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.cableflux.pipes.impl;

import com.zeitheron.hammercore.tile.tooltip.ProgressBar;
import com.zeitheron.hammercore.tile.tooltip.SimpleProgressBar;
import com.zeitheron.hammercore.tile.tooltip.own.IRenderableInfo;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.tile.tooltip.own.inf.ProgressBarTooltipInfo;
import com.zeitheron.hammercore.tile.tooltip.own.inf.StringTooltipInfo;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.cableflux.pipes.BasePipe;
import tk.zeitheron.cableflux.pipes.IPipe;
import tk.zeitheron.cableflux.pipes.PipeGrid;
import tk.zeitheron.cableflux.tiles.TilePipe;
import tk.zeitheron.cableflux.util.ModifiableFEStorage;

public class FEPipe
extends BasePipe {
    public ResourceLocation texture;
    public long capacity;
    public long throughput;
    public ModifiableFEStorage storage;
    SimpleProgressBar energyBar = new SimpleProgressBar();

    public FEPipe(ResourceLocation texture, int capacity, int throughput) {
        this.texture = texture;
        this.storage = new ModifiableFEStorage(capacity, throughput);
        this.capacity = capacity;
        this.throughput = throughput;
    }

    public FEPipe setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public void update(TilePipe tile) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntity te = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(face));
            if (te == null || te instanceof TilePipe || !te.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) continue;
            IEnergyStorage es = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
            if (es != null && es.canExtract()) {
                es.extractEnergy(this.storage.receiveEnergy(es.extractEnergy(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), true), false), false);
            }
            if (es == null || !es.canReceive()) continue;
            es.receiveEnergy(this.storage.extractEnergy(es.receiveEnergy(this.storage.getEnergyStored(), true), false), false);
        }
        if (tile.atTickRate(20)) {
            this.neighborChanged();
        }
        super.update(tile);
    }

    @Override
    public void balanceGrid() {
        PipeGrid pg = this.getGrid();
        if (pg != null) {
            AtomicLong totalFE = new AtomicLong(0L);
            AtomicInteger count = new AtomicInteger(0);
            pg.streamOfPipes(FEPipe.class).forEach(fe -> {
                totalFE.addAndGet(fe.storage.getEnergyStored());
                count.incrementAndGet();
            });
            if (count.intValue() != pg.pipes.size()) {
                pg.majorGridChange();
                return;
            }
            int fePer = Math.max(0, (int)(totalFE.longValue() / (long)count.intValue()));
            pg.streamOfPipes(FEPipe.class).forEach(fe -> fe.storage.setEnergyStored(fePer));
            int left = (int)(totalFE.longValue() - (long)(fePer * count.intValue()));
            this.storage.setEnergyStored(this.storage.getEnergyStored() + left);
        }
    }

    @Override
    public void write(NBTTagCompound nbt) {
        this.storage.writeToNBT(nbt);
    }

    @Override
    public void read(NBTTagCompound nbt) {
        this.storage.readFromNBT(nbt);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public boolean testConnectionTo(EnumFacing facing, IPipe other) {
        TileEntity te = this.world.func_175625_s(this.pos.func_177972_a(facing));
        if (te == null || te instanceof EnergyStorageTile) {
            return false;
        }
        if (te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
            return true;
        }
        return other instanceof FEPipe;
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)((Object)(capability == CapabilityEnergy.ENERGY ? this.storage : null));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(ITooltip tooltip) {
        long en = Math.min(this.capacity, (long)this.storage.getEnergyStored());
        this.energyBar.setProgress((float)Math.max(0.0, (double)en / (double)this.capacity - 0.01));
        int rgb = MathHelper.func_181758_c((float)(0.999f - (float)this.energyBar.getProgressPercent() / 100.0f / 2.0f), (float)1.0f, (float)1.0f);
        this.energyBar.filledMainColor = -65536;
        this.energyBar.filledAlternateColor = -6946816;
        this.energyBar.backgroundColor = ColorHelper.packARGB((float)1.0f, (float)(ColorHelper.getRed((int)rgb) * 0.35f), (float)(ColorHelper.getGreen((int)rgb) * 0.35f), (float)(ColorHelper.getBlue((int)rgb) * 0.35f));
        this.energyBar.borderColor = -9079435;
        StringTooltipInfo i = new StringTooltipInfo(String.format("%,d", en));
        i.color = rgb;
        tooltip.append((IRenderableInfo)i);
        tooltip.append((IRenderableInfo)new StringTooltipInfo(String.format(" / %,d FE:", this.capacity)));
        tooltip.newLine();
        tooltip.append((IRenderableInfo)new ProgressBarTooltipInfo((ProgressBar)this.energyBar));
    }
}

