/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.cableflux.pipes;

import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.utils.PositionedStateImplementation;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.cableflux.cfg.ConfigCF;
import tk.zeitheron.cableflux.client.BakedPipeModel;
import tk.zeitheron.cableflux.pipes.IPipeImage;
import tk.zeitheron.cableflux.pipes.PipeGrid;
import tk.zeitheron.cableflux.tiles.TilePipe;

public interface IPipe
extends IPipeImage {
    public static final Cuboid6 CENTER = new Cuboid6(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    public static final Cuboid6 DOWN_CENTER = new Cuboid6(0.34375, 0.0, 0.34375, 0.65625, 0.3125, 0.65625);
    public static final Cuboid6 CENTER_UP = new Cuboid6(0.34375, 0.65625, 0.34375, 0.65625, 1.0, 0.65625);
    public static final Cuboid6 NORH_CENTER = new Cuboid6(0.34375, 0.34375, 0.0, 0.65625, 0.65625, 0.3125);
    public static final Cuboid6 CENTER_SOUTH = new Cuboid6(0.34375, 0.34375, 0.65625, 0.65625, 0.65625, 1.0);
    public static final Cuboid6 WEST_CENTER = new Cuboid6(0.0, 0.34375, 0.34375, 0.3125, 0.65625, 0.65625);
    public static final Cuboid6 CENTER_EAST = new Cuboid6(0.65625, 0.34375, 0.34375, 1.0, 0.65625, 0.65625);

    default public boolean canAddToSameGrid(IPipe other) {
        return other != null && this.getClass().isAssignableFrom(other.getClass());
    }

    public BlockPos getCoords();

    public void setCoords(BlockPos var1);

    public World getWorld();

    public void setWorld(World var1);

    public PipeGrid getGrid();

    public void setGrid(PipeGrid var1);

    public void kill();

    public boolean isDead();

    default public void neighborChanged() {
    }

    default public void update(TilePipe tile) {
        this.setCoords(tile.func_174877_v());
        this.setWorld(tile.func_145831_w());
        PipeGrid grid = this.getGrid();
        if (grid != null && grid.getMasterPipe() == this && tile.atTickRate(2)) {
            this.balanceGrid();
        }
    }

    default public void balanceGrid() {
    }

    default public void read(NBTTagCompound nbt) {
    }

    default public void write(NBTTagCompound nbt) {
    }

    default public void createDrops(WorldLocation at) {
        PipeGrid grid = this.getGrid();
        if (grid != null) {
            grid.majorGridChange();
        }
    }

    default public void addCuboids(List<Cuboid6> cubes) {
        cubes.add(CENTER);
        if (this.isConnectedTo(EnumFacing.DOWN)) {
            cubes.add(DOWN_CENTER);
        }
        if (this.isConnectedTo(EnumFacing.UP)) {
            cubes.add(CENTER_UP);
        }
        if (this.isConnectedTo(EnumFacing.NORTH)) {
            cubes.add(NORH_CENTER);
        }
        if (this.isConnectedTo(EnumFacing.SOUTH)) {
            cubes.add(CENTER_SOUTH);
        }
        if (this.isConnectedTo(EnumFacing.WEST)) {
            cubes.add(WEST_CENTER);
        }
        if (this.isConnectedTo(EnumFacing.EAST)) {
            cubes.add(CENTER_EAST);
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void hookTooltip(ITooltip tooltip) {
        if (ConfigCF.showHUD) {
            this.addTooltip(tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void addTooltip(ITooltip tooltip) {
    }

    default public <T> boolean hasCapability(Capability<T> capability, EnumFacing facing) {
        return false;
    }

    default public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public void generateBakedQuads(List<BakedQuad> quads, EnumFacing side, long rand, IBlockAccess world, BlockPos pos, PositionedStateImplementation state, Predicate<EnumFacing> connetions, TextureAtlasSprite sprite) {
        BakedPipeModel.generateQuads(quads, side, rand, world, pos, state, connetions, sprite);
    }
}

