/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.cableflux.blocks;

import com.zeitheron.hammercore.api.ITileBlock;
import com.zeitheron.hammercore.api.blocks.INoBlockstate;
import com.zeitheron.hammercore.api.inconnect.InConnectAPI;
import com.zeitheron.hammercore.api.mhb.BlockTraceable;
import com.zeitheron.hammercore.api.mhb.ICubeManager;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tk.zeitheron.cableflux.pipes.IPipe;
import tk.zeitheron.cableflux.pipes.IPipeImage;
import tk.zeitheron.cableflux.pipes.PipeManager;
import tk.zeitheron.cableflux.tiles.TilePipe;

public class BlockPipe
extends BlockTraceable
implements ITileBlock<TilePipe>,
ICubeManager,
IPipeImage,
INoBlockstate {
    public final Supplier<IPipe> ptype;
    public ResourceLocation texture;
    private static final ThreadLocal<List<Cuboid6>> cubeLists = ThreadLocal.withInitial(ArrayList::new);

    public BlockPipe(Material mat, Supplier<IPipe> type) {
        super(mat);
        this.ptype = type;
        this.func_149711_c(0.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return InConnectAPI.makeExtendedPositionedState((IBlockAccess)world, (BlockPos)pos, (IBlockState)state);
    }

    public BlockPipe setTranslationKey(String name) {
        super.func_149663_c(name);
        return this;
    }

    public Class<TilePipe> getTileClass() {
        return TilePipe.class;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TilePipe tile = (TilePipe)((Object)WorldUtil.cast((Object)world.func_175625_s(pos), TilePipe.class));
        if (tile != null) {
            tile.neighborChanged();
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TilePipe tile = (TilePipe)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TilePipe.class));
        if (tile != null) {
            tile.neighborChanged();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TilePipe tile = (TilePipe)((Object)WorldUtil.cast((Object)worldIn.func_175625_s(pos), TilePipe.class));
        if (tile != null && tile.pipe != null) {
            tile.pipe.createDrops(new WorldLocation(worldIn, pos));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public Cuboid6[] getCuboids(World world, BlockPos pos, IBlockState state) {
        IPipe pipe = PipeManager.getPipe((IBlockAccess)world, pos);
        if (pipe != null) {
            List<Cuboid6> c = cubeLists.get();
            c.clear();
            pipe.addCuboids(c);
            return c.toArray(new Cuboid6[c.size()]);
        }
        return new Cuboid6[0];
    }

    public BlockPipe setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public boolean isConnectedTo(EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y;
    }
}

