/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.ExternalFontManager;
import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.gui.GuiCommon;
import bre.smoothfont.gui.GuiScreenEx;
import bre.smoothfont.gui.GuiSliderEx;
import bre.smoothfont.gui.GuiSliderFontRes;
import bre.smoothfont.gui.GuiTextFieldWithLabel;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFontSelection
extends GuiScreenEx {
    private FontList guiList;
    private GuiButton antiAliasBtn;
    private GuiButton styleBtn;
    private GuiButton doubleRenderBtn;
    private GuiButton detailListBtn;
    private GuiButton applyBtn;
    private GuiButton finishBtn;
    private GuiSliderFontRes fontResSld;
    private GuiButton autoSizingBtn;
    private GuiSliderEx fontSizeSld;
    private GuiSliderEx fontGapSld;
    private GuiSliderEx spaceWidthSld;
    private GuiButton alignBaselineBtn;
    private GuiButton targetToReplaceBtn;
    private GuiTextField fontFilterField;
    private GuiSliderEx widthFactorDefaultSld;
    private GuiSliderEx widthFactorUnicodeSld;
    private final int DX = 160;
    private final int BTN_HEIGHT = 20;
    private final int BTN_VGAP = 2;
    private final int BTN_HGAP = 4;
    private final int BTN_WIDTH2 = 158;
    private final int BTN_WIDTH3 = 104;
    private final int BTN_WIDTH6 = 50;
    private final int SLOT_HEIGHT = 16;
    private final int TOP_MARGIN = 2;
    private final int BOTTOM_MARGIN = 2;
    private String filterText = "";
    private int tmpConfigAntiAlias;
    private int tmpConfigDoubleRendering;
    private int tmpConfigFontResIndex;
    private int tmpConfigFontGap;
    private double tmpConfigFontSizeScaleFactor;
    private boolean tmpConfigFontAutoSizing;
    private String tmpConfigFontName;
    private String tmpConfigSecondaryFontName;
    private int tmpConfigPrimaryFontStyle;
    private int tmpConfigSecondaryFontStyle;
    private double tmpConfigWidthFactorDefault;
    private double tmpConfigWidthFactorUnicode;
    private int BTN_ROW1;
    private int BTN_ROW2;
    private int BTN_ROW3;
    private int BTN_ROW4;

    public GuiFontSelection(GuiScreen parent) {
        super(parent);
        this.tmpConfigAntiAlias = CommonConfig.currentConfig.fontAntiAlias;
        this.tmpConfigDoubleRendering = CommonConfig.currentConfig.fontEmphasis;
        this.tmpConfigFontResIndex = CommonConfig.currentConfig.fontResIndex;
        this.tmpConfigFontGap = CommonConfig.currentConfig.fontGap;
        this.tmpConfigFontSizeScaleFactor = CommonConfig.currentConfig.fontSizeScaleFactor;
        this.tmpConfigFontAutoSizing = CommonConfig.currentConfig.fontAutoSizing;
        if (CommonConfig.currentConfig.useOSFont) {
            this.tmpConfigFontName = CommonConfig.currentConfig.fontName;
            this.tmpConfigPrimaryFontStyle = CommonConfig.currentConfig.primaryFontStyle;
        } else {
            this.tmpConfigFontName = "Minecraft font (default)";
            this.tmpConfigPrimaryFontStyle = 0;
        }
        this.tmpConfigSecondaryFontName = CommonConfig.currentConfig.secondaryFontName;
        this.tmpConfigSecondaryFontStyle = CommonConfig.currentConfig.secondaryFontStyle;
        this.tmpConfigWidthFactorDefault = CommonConfig.currentConfig.widthFactorDefaultCharset;
        this.tmpConfigWidthFactorUnicode = CommonConfig.currentConfig.widthFactorUnicodeCharset;
    }

    public void func_73866_w_() {
        this.BTN_ROW1 = this.field_146295_m - 2 - 80 - 6;
        this.BTN_ROW2 = this.field_146295_m - 2 - 60 - 4;
        this.BTN_ROW3 = this.field_146295_m - 2 - 40 - 2;
        this.BTN_ROW4 = this.field_146295_m - 2 - 20;
        this.field_146292_n.clear();
        this.fontFilterField = new GuiTextFieldWithLabel(GuiPart.FIELD_FILTER.ordinal(), this.field_146289_q, this.field_146294_l - 130 + 50, 2, 70, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontFilter", (Object[])new Object[0])){

            public boolean func_146192_a(int posX, int posY, int which) {
                boolean flag;
                boolean bl = flag = posX >= this.field_146209_f && posX < this.field_146209_f + this.field_146218_h && posY >= this.field_146210_g && posY < this.field_146210_g + this.field_146219_i;
                if (flag) {
                    switch (which) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            GuiFontSelection.this.filterText = "";
                            this.func_146180_a(GuiFontSelection.this.filterText);
                            GuiFontSelection.this.guiList.filteredFontList.clear();
                            GuiFontSelection.this.guiList.filteredFontList.addAll(GuiFontSelection.this.guiList.fontList);
                            GuiFontSelection.this.guiList.func_148145_f(-GuiFontSelection.this.guiList.func_148148_g());
                            GuiFontSelection.this.guiList.func_148145_f(GuiFontSelection.this.guiList.filteredFontList.indexOf(GuiFontSelection.this.tmpConfigFontName) * 16);
                            break;
                        }
                    }
                }
                return super.func_146192_a(posX, posY, which);
            }
        };
        this.textFieldList.add(this.fontFilterField);
        this.fontFilterField.func_146195_b(true);
        this.hoverCheckerMap.put(GuiPart.FIELD_FILTER, new HoverChecker(this.fontFilterField.field_146210_g, this.fontFilterField.field_146210_g + this.fontFilterField.field_146219_i, this.fontFilterField.field_146209_f, this.fontFilterField.field_146209_f + this.fontFilterField.field_146218_h, 500));
        this.fontGapSld = (GuiSliderEx)this.func_189646_b((GuiButton)new GuiSliderEx(GuiPart.SLD_FONT_GAP.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontGap", (Object[])new Object[0]) + ": ", "", -3.0, 2.0, this.tmpConfigFontGap, false, false, true, I18n.func_135052_a((String)"smoothfont.config.font.fontGap.normal", (Object[])new Object[0]), 0.0){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.fontGapSld.setSpecialVal(0.0).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.font.fontGap.normal", (Object[])new Object[0])).updateSlider();
        this.hoverCheckerMap.put(GuiPart.SLD_FONT_GAP, new HoverChecker((GuiButton)this.fontGapSld, 500));
        this.fontSizeSld = (GuiSliderEx)this.func_189646_b((GuiButton)new GuiSliderEx(GuiPart.SLD_FONT_SIZE.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontSize", (Object[])new Object[0]) + ": ", "", 0.5, 1.5, this.tmpConfigFontSizeScaleFactor, true, true, true, I18n.func_135052_a((String)"smoothfont.config.font.size.normal", (Object[])new Object[0]), 1.0){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.fontSizeSld.setSpecialVal(1.0).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.font.size.normal", (Object[])new Object[0])).setValueResolution(0.01).setDisplayPrecision(2).updateSlider();
        this.hoverCheckerMap.put(GuiPart.SLD_FONT_SIZE, new HoverChecker((GuiButton)this.fontSizeSld, 500));
        this.widthFactorDefaultSld = (GuiSliderEx)this.func_189646_b((GuiButton)new GuiSliderEx(GuiPart.SLD_WIDTH_DEFAULT.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW3, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontWidthDefault", (Object[])new Object[0]) + ": ", "", 0.5, 1.5, this.tmpConfigWidthFactorDefault, true, true, true, I18n.func_135052_a((String)"smoothfont.config.font.fontWidth.normal", (Object[])new Object[0]), 1.0){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.widthFactorDefaultSld.setSpecialVal(1.0).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.font.fontWidth.normal", (Object[])new Object[0])).setValueResolution(0.01).setDisplayPrecision(2).updateSliderString();
        this.hoverCheckerMap.put(GuiPart.SLD_WIDTH_DEFAULT, new HoverChecker((GuiButton)this.widthFactorDefaultSld, 500));
        this.widthFactorUnicodeSld = (GuiSliderEx)this.func_189646_b((GuiButton)new GuiSliderEx(GuiPart.SLD_WIDTH_UNICODE.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW4, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontWidthUnicode", (Object[])new Object[0]) + ": ", "", 0.5, 1.5, this.tmpConfigWidthFactorUnicode, true, true, true, I18n.func_135052_a((String)"smoothfont.config.font.fontWidth.normal", (Object[])new Object[0]), 1.0){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.widthFactorUnicodeSld.setSpecialVal(1.0).setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.font.fontWidth.normal", (Object[])new Object[0])).setValueResolution(0.01).setDisplayPrecision(2).updateSliderString();
        this.hoverCheckerMap.put(GuiPart.SLD_WIDTH_UNICODE, new HoverChecker((GuiButton)this.widthFactorUnicodeSld, 500));
        int maxFontSizeIndex = FontUtils.getMaxFontSizeIndex();
        this.fontResSld = (GuiSliderFontRes)this.func_189646_b((GuiButton)new GuiSliderFontRes(GuiPart.SLD_FONT_RES.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW1, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontRes", (Object[])new Object[0]) + ": ", "", 0.0, maxFontSizeIndex, this.tmpConfigFontResIndex, false, true, null){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.hoverCheckerMap.put(GuiPart.SLD_FONT_RES, new HoverChecker((GuiButton)this.fontResSld, 500));
        this.spaceWidthSld = (GuiSliderEx)this.func_189646_b((GuiButton)new GuiSliderEx(GuiPart.SLD_SPACE_WIDTH.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW3, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.spaceWidth", (Object[])new Object[0]) + ": ", "", 0.0, 4.0, CommonConfig.currentConfig.fontSpaceWidth, false, false, true, I18n.func_135052_a((String)"smoothfont.config.font.spaceWidth.normal", (Object[])new Object[0]), 4.0){

            @Override
            protected void valueChanged() {
                try {
                    GuiFontSelection.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.spaceWidthSld.setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.auto", (Object[])new Object[0])).setSpecialVal(0.0).updateSliderString();
        this.hoverCheckerMap.put(GuiPart.SLD_SPACE_WIDTH, new HoverChecker((GuiButton)this.spaceWidthSld, 500));
        this.autoSizingBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_AUTO_SIZING.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW1, 104, 20, this.tmpConfigFontAutoSizing ? I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.fixed", (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_AUTO_SIZING, new HoverChecker(this.autoSizingBtn, 500));
        this.doubleRenderBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_DOUBLE_RENDERING.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW3, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.doubleRendering", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.doubleRendering." + this.tmpConfigDoubleRendering), (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_DOUBLE_RENDERING, new HoverChecker(this.doubleRenderBtn, 500));
        this.antiAliasBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_ANTI_ALIAS.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW1, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.antiAlias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.antiAlias." + this.tmpConfigAntiAlias), (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_ANTI_ALIAS, new HoverChecker(this.antiAliasBtn, 500));
        this.styleBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_STYLE.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.style", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.style." + this.getSelectedFontStyle()), (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_STYLE, new HoverChecker(this.styleBtn, 500));
        this.detailListBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_DETAIL_LIST.ordinal(), this.field_146294_l - 130, 2, 40, 20, I18n.func_135052_a((String)("smoothfont.config.font.fontDetailList." + (CommonConfig.currentConfig.fontDetailList ? "on" : "off")), (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_DETAIL_LIST, new HoverChecker(this.detailListBtn, 500));
        this.alignBaselineBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_ALIGN_BASELINE.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW4, 104, 20, CommonConfig.currentConfig.fontAlignBaseline ? I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline2.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline2.off", (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_ALIGN_BASELINE, new HoverChecker(this.alignBaselineBtn, 500));
        this.targetToReplaceBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_TARGET_TO_REPLACE.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW4, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.targetToReplace", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.targetToReplace." + CommonConfig.currentConfig.fontTargetToReplace), (Object[])new Object[0])));
        this.hoverCheckerMap.put(GuiPart.BTN_TARGET_TO_REPLACE, new HoverChecker(this.targetToReplaceBtn, 500));
        this.targetToReplaceBtn.field_146125_m = false;
        this.applyBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_APPLY.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW4, 50, 20, I18n.func_135052_a((String)"smoothfont.config.font.apply", (Object[])new Object[0])));
        this.finishBtn = this.func_189646_b(new GuiButton(GuiPart.BTN_FINISH.ordinal(), this.field_146294_l / 2 - 160 + 270, this.BTN_ROW4, 50, 20, I18n.func_135052_a((String)"smoothfont.config.font.finish", (Object[])new Object[0])));
        this.guiList = new FontList(this.field_146297_k);
        this.guiList.func_148134_d(7, 8);
        this.hoverCheckerMap.put(GuiPart.SLOT_FONT_LIST, new HoverChecker(this.guiList.field_148153_b, this.guiList.field_148154_c, this.guiList.field_148155_a / 2 - 75, this.guiList.field_148155_a / 2 + 75, 500));
        this.guiList.func_148145_f(this.guiList.filteredFontList.indexOf(this.tmpConfigFontName) * 16);
        this.hoverCheckerMap.put(GuiPart.TEXT_MEM_USAGE, new HoverChecker(0, this.field_146289_q.field_78288_b + 2, 0, this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"smoothfont.config.font.memUsage", (Object[])new Object[0])) + 2, 500));
        this.updateGuiParts();
    }

    private int getSelectedFontStyle() {
        if (this.tmpConfigFontName.equals(this.tmpConfigSecondaryFontName)) {
            return this.tmpConfigSecondaryFontStyle;
        }
        return this.tmpConfigPrimaryFontStyle;
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.guiList.func_178039_p();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            GuiPart[] guiPartArray = GuiPart.values();
            GuiPart guiPart = guiPartArray[button.field_146127_k];
            switch (guiPart) {
                case BTN_ANTI_ALIAS: {
                    ++this.tmpConfigAntiAlias;
                    if (this.tmpConfigAntiAlias > 2) {
                        this.tmpConfigAntiAlias = 0;
                    }
                    this.antiAliasBtn.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.antiAlias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.antiAlias." + this.tmpConfigAntiAlias), (Object[])new Object[0]);
                    break;
                }
                case BTN_STYLE: {
                    if (this.tmpConfigFontName.equals(this.tmpConfigSecondaryFontName)) {
                        ++this.tmpConfigSecondaryFontStyle;
                        if (this.tmpConfigSecondaryFontStyle > 3) {
                            this.tmpConfigSecondaryFontStyle = 0;
                        }
                    } else {
                        ++this.tmpConfigPrimaryFontStyle;
                        if (this.tmpConfigPrimaryFontStyle > 3) {
                            this.tmpConfigPrimaryFontStyle = 0;
                        }
                    }
                    button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.style", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.style." + this.getSelectedFontStyle()), (Object[])new Object[0]);
                    break;
                }
                case BTN_DOUBLE_RENDERING: {
                    ++this.tmpConfigDoubleRendering;
                    if (this.tmpConfigDoubleRendering > 3) {
                        this.tmpConfigDoubleRendering = 0;
                    }
                    button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.doubleRendering", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.doubleRendering." + this.tmpConfigDoubleRendering), (Object[])new Object[0]);
                    break;
                }
                case SLD_FONT_RES: {
                    this.tmpConfigFontResIndex = ((GuiSlider)button).getValueInt();
                    break;
                }
                case BTN_AUTO_SIZING: {
                    this.tmpConfigFontAutoSizing = !this.tmpConfigFontAutoSizing;
                    button.field_146126_j = this.tmpConfigFontAutoSizing ? I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.fixed", (Object[])new Object[0]);
                    break;
                }
                case SLD_FONT_SIZE: {
                    this.tmpConfigFontSizeScaleFactor = ((GuiSliderEx)button).getValueEx();
                    break;
                }
                case SLD_FONT_GAP: {
                    this.tmpConfigFontGap = ((GuiSlider)button).getValueInt();
                    break;
                }
                case SLD_SPACE_WIDTH: {
                    CommonConfig.currentConfig.fontSpaceWidth = ((GuiSliderEx)button).getValueInt();
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case BTN_DETAIL_LIST: {
                    CommonConfig.currentConfig.fontDetailList = !CommonConfig.currentConfig.fontDetailList;
                    button.field_146126_j = I18n.func_135052_a((String)("smoothfont.config.font.fontDetailList." + (CommonConfig.currentConfig.fontDetailList ? "on" : "off")), (Object[])new Object[0]);
                    this.guiList = new FontList(this.field_146297_k);
                    this.guiList.func_148134_d(7, 8);
                    this.guiList.func_148145_f(this.guiList.filteredFontList.indexOf(this.tmpConfigFontName) * 16);
                    break;
                }
                case BTN_ALIGN_BASELINE: {
                    CommonConfig.currentConfig.fontAlignBaseline = !CommonConfig.currentConfig.fontAlignBaseline;
                    button.field_146126_j = CommonConfig.currentConfig.fontAlignBaseline ? I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline2.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline2.off", (Object[])new Object[0]);
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case BTN_TARGET_TO_REPLACE: {
                    CommonConfig.currentConfig.fontTargetToReplace = CommonConfig.currentConfig.fontTargetToReplace == 0 ? 1 : 0;
                    button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.targetToReplace", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.targetToReplace." + CommonConfig.currentConfig.fontTargetToReplace), (Object[])new Object[0]);
                    FontRendererHook.updateChangeFontFlagAll();
                    FontRendererHook.updateHookFlagsAll();
                    GuiFontSelection.refreshFontResources();
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case SLD_WIDTH_DEFAULT: {
                    this.tmpConfigWidthFactorDefault = ((GuiSliderEx)button).getValueEx();
                    break;
                }
                case SLD_WIDTH_UNICODE: {
                    this.tmpConfigWidthFactorUnicode = ((GuiSliderEx)button).getValueEx();
                    break;
                }
                case BTN_APPLY: {
                    this.applyFontSetting(GuiFontSelection.func_146272_n());
                    break;
                }
                case BTN_FINISH: {
                    this.applyFontSetting(GuiFontSelection.func_146272_n());
                    this.field_146297_k.func_147108_a(this.parentScreen);
                    break;
                }
                default: {
                    this.guiList.func_148147_a(button);
                }
            }
        }
    }

    private void applyFontSetting(boolean force) {
        if (this.tmpConfigFontName.equals(this.tmpConfigSecondaryFontName)) {
            this.tmpConfigPrimaryFontStyle = this.tmpConfigSecondaryFontStyle;
        }
        if (!FontRasterizer.getInstance().glyphsGenerationError && !force && this.tmpConfigAntiAlias == CommonConfig.currentConfig.fontAntiAlias && this.tmpConfigDoubleRendering == CommonConfig.currentConfig.fontEmphasis && this.tmpConfigFontResIndex == CommonConfig.currentConfig.fontResIndex && this.tmpConfigFontSizeScaleFactor == CommonConfig.currentConfig.fontSizeScaleFactor && this.tmpConfigFontAutoSizing == CommonConfig.currentConfig.fontAutoSizing && this.tmpConfigFontGap == CommonConfig.currentConfig.fontGap && this.tmpConfigFontName.equals(CommonConfig.currentConfig.fontName) && this.tmpConfigSecondaryFontName.equals(CommonConfig.currentConfig.secondaryFontName) && this.tmpConfigPrimaryFontStyle == CommonConfig.currentConfig.primaryFontStyle && this.tmpConfigSecondaryFontStyle == CommonConfig.currentConfig.secondaryFontStyle && this.tmpConfigWidthFactorDefault == CommonConfig.currentConfig.widthFactorDefaultCharset && this.tmpConfigWidthFactorUnicode == CommonConfig.currentConfig.widthFactorUnicodeCharset) {
            return;
        }
        FontRasterizer.getInstance().glyphsGenerationError = false;
        CommonConfig.currentConfig.fontAntiAlias = this.tmpConfigAntiAlias;
        CommonConfig.currentConfig.fontEmphasis = this.tmpConfigDoubleRendering;
        CommonConfig.currentConfig.fontResIndex = this.tmpConfigFontResIndex;
        CommonConfig.currentConfig.fontSizeScaleFactor = this.tmpConfigFontSizeScaleFactor;
        CommonConfig.currentConfig.fontAutoSizing = this.tmpConfigFontAutoSizing;
        CommonConfig.currentConfig.fontGap = this.tmpConfigFontGap;
        CommonConfig.currentConfig.fontName = this.tmpConfigFontName;
        CommonConfig.currentConfig.secondaryFontName = this.tmpConfigSecondaryFontName;
        CommonConfig.currentConfig.primaryFontStyle = this.tmpConfigPrimaryFontStyle;
        CommonConfig.currentConfig.secondaryFontStyle = this.tmpConfigSecondaryFontStyle;
        CommonConfig.currentConfig.widthFactorDefaultCharset = this.tmpConfigWidthFactorDefault;
        CommonConfig.currentConfig.widthFactorUnicodeCharset = this.tmpConfigWidthFactorUnicode;
        CommonConfig.currentConfig.useOSFont = !this.tmpConfigFontName.equals("Minecraft font (default)");
        CommonConfig.saveCurrentConfig();
        if (CommonConfig.currentConfig.useOSFont) {
            GuiFontSelection.reloadFonts();
        } else {
            GuiFontSelection.reloadFonts();
        }
    }

    public static void reloadFonts() {
        FontRendererHook.updateChangeFontFlagAll();
        FontRendererHook.updateHookFlagsAll();
        if (!CommonConfig.currentConfig.useOSFont) {
            FontRasterizer.getInstance().clearFontCache();
        } else {
            int fontRes = FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
            boolean result = FontRasterizer.getInstance().setFontSafely(CommonConfig.currentConfig.fontName, CommonConfig.currentConfig.secondaryFontName, CommonConfig.currentConfig.primaryFontStyle, CommonConfig.currentConfig.secondaryFontStyle, fontRes, CommonConfig.currentConfig.fontGap, CommonConfig.currentConfig.fontSizeScaleFactor, CommonConfig.currentConfig.fontAntiAlias, CommonConfig.currentConfig.fontEmphasis, CommonConfig.currentConfig.widthFactorDefaultCharset, CommonConfig.currentConfig.widthFactorUnicodeCharset, false);
            if (!result) {
                FontRendererHook.clearChangeFontFlagAll();
                FontRendererHook.updateHookFlagsAll();
                FontRasterizer.getInstance().clearFontCache();
            }
        }
        GuiFontSelection.refreshFontResources();
    }

    private static void refreshFontResources() {
        FontTextureManager.getInstance().func_110549_a(Minecraft.func_71410_x().func_110442_L());
    }

    public void func_73876_c() {
        this.fontFilterField.func_146178_a();
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.guiList.func_148128_a(mouseX, mouseY, partialTicks);
        this.fontFilterField.func_146194_f();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.config.font.title", (Object[])new Object[0]), this.field_146294_l / 2, 10, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (FontRasterizer.getInstance().glyphsGenerationError) {
            this.func_73731_b(this.field_146289_q, "Failed to change fonts: " + FontRasterizer.getInstance().glyphsGenerationErrorMessage, 2, 2, 0xFF0000);
        } else {
            float totalImageSizeMB = (float)FontRasterizer.getInstance().totalImageSize / 1024.0f / 1024.0f;
            String memUsageText = I18n.func_135052_a((String)"smoothfont.config.font.memUsage", (Object[])new Object[0]) + ": ";
            memUsageText = totalImageSizeMB >= 10.0f ? memUsageText + String.format("%dMB", (int)totalImageSizeMB) : memUsageText + String.format("%.1fMB", Float.valueOf(totalImageSizeMB));
            this.func_73731_b(this.field_146289_q, memUsageText, 2, 2, 0xB0B0B0);
        }
        this.drawTooltip(mouseX, mouseY);
    }

    @Override
    public void func_73869_a(char ch, int code) throws IOException {
        super.func_73869_a(ch, code);
        if (this.fontFilterField.func_146206_l()) {
            if (GuiFontSelection.func_146271_m() && code == 35) {
                this.fontFilterField.func_146175_b(-1);
            } else {
                this.fontFilterField.func_146201_a(ch, code);
            }
            this.filterText = this.fontFilterField.func_146179_b();
            this.guiList.filteredFontList.clear();
            for (String fontName : this.guiList.fontList) {
                if (!Normalizer.normalize(fontName, Normalizer.Form.NFKC).toLowerCase().contains(Normalizer.normalize(this.filterText, Normalizer.Form.NFKC).toLowerCase())) continue;
                this.guiList.filteredFontList.add(fontName);
            }
        }
        if (code == 63) {
            ExternalFontManager.getInstance().registerExternalFonts();
            this.func_73866_w_();
        }
    }

    public void func_73864_a(int posX, int posY, int which) {
        if (this.fontFilterField.func_146176_q()) {
            this.fontFilterField.func_146192_a(posX, posY, which);
        }
        try {
            super.func_73864_a(posX, posY, which);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawTooltip(int mouseX, int mouseY) {
        block18: for (GuiPart gp : GuiPart.values()) {
            HoverChecker hoverChecker = (HoverChecker)this.hoverCheckerMap.get((Object)gp);
            if (hoverChecker == null || !hoverChecker.checkHover(mouseX, mouseY)) continue;
            switch (gp) {
                case SLOT_FONT_LIST: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontNameList", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_DETAIL_LIST: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontDetailList", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case FIELD_FILTER: {
                    continue block18;
                }
                case SLD_FONT_GAP: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontGap", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case SLD_SPACE_WIDTH: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.spaceWidth", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case SLD_FONT_RES: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontRes", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_AUTO_SIZING: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontAutoSizing", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case SLD_FONT_SIZE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontSize", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_ANTI_ALIAS: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.antiAlias", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_STYLE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.style", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_DOUBLE_RENDERING: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.doubleRendering", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_ALIGN_BASELINE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontAlignBaseline2", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case BTN_TARGET_TO_REPLACE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.targetToReplace", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case SLD_WIDTH_DEFAULT: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.widthFactorDefault", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case SLD_WIDTH_UNICODE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.widthFactorUnicode", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
                case TEXT_MEM_USAGE: {
                    this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.memUsage", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                    continue block18;
                }
            }
        }
    }

    private List strToList(String str) {
        return GuiCommon.strToList(this.field_146289_q, Math.min(200, this.field_146294_l / 2 - 20), str);
    }

    private void updateGuiParts() {
        boolean btnEnabled;
        this.widthFactorDefaultSld.field_146124_l = btnEnabled = !"Minecraft font (default)".equals(this.tmpConfigFontName);
        this.widthFactorUnicodeSld.field_146124_l = btnEnabled;
        this.fontGapSld.field_146124_l = btnEnabled;
        this.fontSizeSld.field_146124_l = btnEnabled;
        this.fontResSld.field_146124_l = btnEnabled;
        this.spaceWidthSld.field_146124_l = btnEnabled;
        this.autoSizingBtn.field_146124_l = btnEnabled;
        this.doubleRenderBtn.field_146124_l = btnEnabled;
        this.antiAliasBtn.field_146124_l = btnEnabled;
        this.styleBtn.field_146124_l = btnEnabled;
        this.alignBaselineBtn.field_146124_l = btnEnabled;
        this.targetToReplaceBtn.field_146124_l = btnEnabled;
    }

    @SideOnly(value=Side.CLIENT)
    class FontList
    extends GuiSlot {
        private final List<String> fontList;
        private List<String> filteredFontList;
        private boolean elementClickedExecuted;

        public FontList(Minecraft mc) {
            super(mc, GuiFontSelection.this.field_146294_l, GuiFontSelection.this.field_146295_m, 24, GuiFontSelection.this.BTN_ROW1 - 2, 16);
            this.fontList = new ArrayList<String>();
            this.filteredFontList = new ArrayList<String>();
            this.elementClickedExecuted = false;
            this.fontList.add("Minecraft font (default)");
            if (CommonConfig.currentConfig.fontDetailList) {
                this.fontList.addAll(FontUtils.getFontList());
            } else {
                this.fontList.addAll(FontUtils.getFontFamilyList());
            }
            for (String fontName : this.fontList) {
                if (!Normalizer.normalize(fontName, Normalizer.Form.NFKC).toLowerCase().contains(Normalizer.normalize(GuiFontSelection.this.filterText, Normalizer.Form.NFKC).toLowerCase())) continue;
                this.filteredFontList.add(fontName);
            }
            if (GuiFontSelection.this.tmpConfigFontName.isEmpty()) {
                if (CommonConfig.currentConfig.useOSFont) {
                    if (this.fontList.indexOf(CommonConfig.currentConfig.fontName) == -1) {
                        GuiFontSelection.this.tmpConfigFontName = CommonConfig.currentConfig.fontName;
                    } else {
                        GuiFontSelection.this.tmpConfigFontName = CommonConfig.currentConfig.fontName;
                    }
                } else {
                    GuiFontSelection.this.tmpConfigFontName = "Minecraft font (default)";
                }
            }
        }

        protected int func_148127_b() {
            return this.filteredFontList.size();
        }

        public void func_178039_p() {
            this.elementClickedExecuted = false;
            super.func_178039_p();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            if (!this.filteredFontList.get(slotIndex).equals("Minecraft font (default)")) {
                if (isDoubleClick || GuiScreen.func_146272_n()) {
                    GuiFontSelection.this.tmpConfigSecondaryFontName = this.filteredFontList.get(slotIndex);
                    return;
                }
                if (GuiScreen.func_146271_m()) {
                    if (this.filteredFontList.get(slotIndex).equals(GuiFontSelection.this.tmpConfigSecondaryFontName)) {
                        if (!this.elementClickedExecuted) {
                            ++GuiFontSelection.this.tmpConfigSecondaryFontStyle;
                            if (GuiFontSelection.this.tmpConfigSecondaryFontStyle > 3) {
                                GuiFontSelection.this.tmpConfigSecondaryFontStyle = 0;
                            }
                            this.elementClickedExecuted = true;
                        }
                    } else if (this.filteredFontList.get(slotIndex).equals(GuiFontSelection.this.tmpConfigFontName) && !this.elementClickedExecuted) {
                        ++GuiFontSelection.this.tmpConfigPrimaryFontStyle;
                        if (GuiFontSelection.this.tmpConfigPrimaryFontStyle > 3) {
                            GuiFontSelection.this.tmpConfigPrimaryFontStyle = 0;
                        }
                        this.elementClickedExecuted = true;
                    }
                }
            }
            GuiFontSelection.this.tmpConfigFontName = this.filteredFontList.get(slotIndex);
            ((GuiFontSelection)GuiFontSelection.this).styleBtn.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.style", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.style." + GuiFontSelection.this.getSelectedFontStyle()), (Object[])new Object[0]);
            GuiFontSelection.this.updateGuiParts();
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.filteredFontList.indexOf(GuiFontSelection.this.tmpConfigFontName);
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 16;
        }

        protected void func_148123_a() {
            GuiFontSelection.this.func_146276_q_();
        }

        protected void func_192637_a(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
            if (this.filteredFontList.get(entryID).equals(GuiFontSelection.this.tmpConfigSecondaryFontName)) {
                GuiFontSelection.this.func_73732_a(GuiFontSelection.this.field_146289_q, this.filteredFontList.get(entryID), this.field_148155_a / 2, yPos + 1, 0xFFFF00);
                this.drawStyleMark(GuiFontSelection.this.tmpConfigSecondaryFontStyle, yPos + 1, 0xB0B000);
            } else if (this.filteredFontList.get(entryID).equals(GuiFontSelection.this.tmpConfigFontName)) {
                GuiFontSelection.this.func_73732_a(GuiFontSelection.this.field_146289_q, this.filteredFontList.get(entryID), this.field_148155_a / 2, yPos + 1, 0xFFFFFF);
                this.drawStyleMark(GuiFontSelection.this.tmpConfigPrimaryFontStyle, yPos + 1, 0xB0B0B0);
            } else {
                GuiFontSelection.this.func_73732_a(GuiFontSelection.this.field_146289_q, this.filteredFontList.get(entryID), this.field_148155_a / 2, yPos + 1, 0xFFFFFF);
            }
        }

        private void drawStyleMark(int style, int posY, int color) {
            String mark;
            int selBoxLeft = this.field_148152_e + (this.field_148155_a / 2 - this.func_148139_c() / 2);
            int selBoxRight = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2;
            switch (style) {
                case 1: {
                    mark = "[B]";
                    break;
                }
                case 2: {
                    mark = "[I]";
                    break;
                }
                case 3: {
                    mark = "[BI]";
                    break;
                }
                default: {
                    mark = "";
                }
            }
            GuiFontSelection.this.func_73731_b(GuiFontSelection.this.field_146289_q, mark, selBoxRight - GuiFontSelection.this.field_146289_q.func_78256_a(mark) - 1, posY, color);
        }
    }

    private static enum GuiPart {
        FIELD_FILTER,
        SLOT_FONT_LIST,
        SLD_FONT_SIZE,
        SLD_FONT_RES,
        BTN_AUTO_SIZING,
        SLD_FONT_GAP,
        SLD_SPACE_WIDTH,
        BTN_DOUBLE_RENDERING,
        BTN_ANTI_ALIAS,
        BTN_STYLE,
        BTN_ALIGN_BASELINE,
        BTN_TARGET_TO_REPLACE,
        SLD_WIDTH_DEFAULT,
        SLD_WIDTH_UNICODE,
        BTN_DETAIL_LIST,
        BTN_APPLY,
        BTN_FINISH,
        TEXT_MEM_USAGE;

    }
}

