/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.reactive;

import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Disposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.NoOpDisposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Processor;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Publisher;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Subscriber;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.TransactionFailedException;
import io.github.lxgaming.sledgehammer.lib.configurate.util.CheckedFunction;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

class MappedProcessor<I, O>
implements Processor.Transactional<I, O> {
    private final Processor.TransactionalIso<O> processor;
    private final AtomicReference<Disposable> disposable = new AtomicReference();
    private final CheckedFunction<? super I, ? extends O, TransactionFailedException> mapper;
    private final @Nullable Publisher<I> parent;

    MappedProcessor(CheckedFunction<? super I, ? extends O, TransactionFailedException> mapper, @Nullable Publisher<I> parent) {
        this.processor = Processor.createTransactional(parent.getExecutor());
        this.mapper = mapper;
        this.parent = parent;
    }

    @Override
    public Disposable subscribe(Subscriber<? super O> subscriber) {
        Disposable ret = this.processor.subscribe(subscriber);
        if (ret != NoOpDisposable.INSTANCE) {
            Disposable ours = this.disposable.updateAndGet(it -> it == null && this.parent != null ? this.parent.subscribe(this) : it);
            if (ours == NoOpDisposable.INSTANCE) {
                this.processor.onClose();
                return NoOpDisposable.INSTANCE;
            }
            return () -> {
                ret.dispose();
                if (!this.hasSubscribers()) {
                    Disposable disposable = this.disposable.getAndSet(null);
                    disposable.dispose();
                }
            };
        }
        return ret;
    }

    @Override
    public boolean hasSubscribers() {
        return this.processor.hasSubscribers();
    }

    @Override
    public Executor getExecutor() {
        return this.processor.getExecutor();
    }

    @Override
    public void beginTransaction(I newValue) throws TransactionFailedException {
        this.processor.beginTransaction(this.mapper.apply(newValue));
    }

    @Override
    public void commit() {
        this.processor.commit();
    }

    @Override
    public void rollback() {
        this.processor.rollback();
    }

    @Override
    public void onError(Throwable e) {
        this.processor.onError(e);
    }

    @Override
    public void onClose() {
        Disposable disposable = this.disposable.getAndSet(null);
        if (disposable != null) {
            disposable.dispose();
        }
        this.processor.onClose();
    }

    @Override
    public void inject(O element) {
        this.processor.submit(element);
    }

    @Override
    public void setFallbackHandler(@Nullable Subscriber<O> subscriber) {
        this.processor.setFallbackHandler(subscriber);
    }

    @Override
    public boolean closeIfUnsubscribed() {
        if (this.processor.closeIfUnsubscribed()) {
            Disposable disposable = this.disposable.getAndSet(null);
            if (disposable != null) {
                disposable.dispose();
            }
            return true;
        }
        return false;
    }
}

