/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.reactive;

import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Disposable;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Publisher;
import io.github.lxgaming.sledgehammer.lib.configurate.reactive.Subscriber;
import io.github.lxgaming.sledgehammer.lib.configurate.util.CheckedSupplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class ExecutePublisher<V>
implements Publisher<V> {
    private final CompletableFuture<V> actor = new CompletableFuture();
    private final Executor executor;

    public ExecutePublisher(CheckedSupplier<V, ?> action, Executor exec) {
        exec.execute(() -> {
            try {
                this.actor.complete(action.get());
            }
            catch (Throwable ex) {
                this.actor.completeExceptionally(ex);
            }
        });
        this.executor = exec;
    }

    @Override
    public Disposable subscribe(Subscriber<? super V> subscriber) {
        AtomicBoolean subscribed = new AtomicBoolean();
        this.actor.whenCompleteAsync((value, err) -> {
            if (subscribed.compareAndSet(true, false)) {
                if (err != null) {
                    subscriber.onError((Throwable)err);
                } else {
                    try {
                        subscriber.submit(value);
                        subscriber.onClose();
                    }
                    catch (Throwable t2) {
                        subscriber.onError(t2);
                    }
                }
            }
        }, this.executor);
        return () -> subscribed.set(false);
    }

    @Override
    public boolean hasSubscribers() {
        return !this.actor.isDone() && this.actor.getNumberOfDependents() > 0;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

