/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Predicate;

final class SuperTypePredicate
implements Predicate<TypeToken<?>> {
    private static final MethodHandle SUPERTYPE_TEST;
    private final TypeToken<?> type;

    SuperTypePredicate(TypeToken<?> type) {
        this.type = type;
    }

    @Override
    public boolean test(TypeToken<?> t2) {
        try {
            return SUPERTYPE_TEST.invokeExact(this.type, t2);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        MethodHandle supertypeTest;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType type = MethodType.methodType(Boolean.TYPE, TypeToken.class);
        try {
            try {
                supertypeTest = lookup.findVirtual(TypeToken.class, "isSupertypeOf", type);
            }
            catch (NoSuchMethodException e1) {
                try {
                    supertypeTest = lookup.findVirtual(TypeToken.class, "isAssignableFrom", type);
                }
                catch (NoSuchMethodException e2) {
                    throw new RuntimeException("Unable to get TypeToken#isSupertypeOf or TypeToken#isAssignableFrom method");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError("Could not access isSupertypeOf/isAssignableFrom method in TypeToken");
        }
        SUPERTYPE_TEST = supertypeTest;
    }
}

