/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemToolVajra
extends ItemElectricTool
implements IStaticTexturedItem,
IMiningDrill {
    public ItemToolVajra() {
        super(0.0f, -3.0f, Item.ToolMaterial.DIAMOND);
        this.setRegistryName("vajra");
        this.setTranslationKey(GravisuitLang.vajra);
        this.field_77865_bY = 1.0f;
        this.maxCharge = GravisuitConfig.powerValues.vajraStorage;
        this.transferLimit = GravisuitConfig.powerValues.vajraTransfer;
        this.tier = 3;
        this.func_77637_a(IC2.tabIC2);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setMaxCharge(int storage) {
        this.maxCharge = storage;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.transferLimit = maxTransfer;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151056_x.func_150897_b(state) || Items.field_151048_u.func_150897_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        return 3;
    }

    public int getEnergyCost(ItemStack stack) {
        return 3333;
    }

    public float getMiningSpeed(ItemStack stack) {
        return 16384.0f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe", (Object)"sword");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean silkTouch = nbt.func_74767_n("silkTouch");
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (silkTouch) {
                nbt.func_74757_a("silkTouch", false);
                enchantments.remove(Enchantments.field_185306_r, 1);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                IC2.platform.messagePlayer(player, GravisuitLang.silkTouchOff);
            } else {
                nbt.func_74757_a("silkTouch", true);
                enchantments.put(Enchantments.field_185306_r, 1);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                IC2.platform.messagePlayer(player, GravisuitLang.silkTouchOn);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        boolean silkTouch = nbt.func_74767_n("silkTouch");
        if (silkTouch) {
            tooltip.add(GravisuitLang.silkMode.getLocalizedFormatted(new Object[]{GravisuitLang.vajraSilktouchOn}));
        } else {
            tooltip.add(GravisuitLang.silkMode.getLocalizedFormatted(new Object[]{GravisuitLang.vajraSilktouchOff}));
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), GravisuitLang.vajraSilktouchToggle.getLocalized()}));
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        if (blockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        float blockHardness = blockState.func_185887_b(worldIn, pos);
        if (blockHardness < 0.0f) {
            return false;
        }
        return blockState.func_177230_c().canHarvestBlock((IBlockAccess)worldIn, pos, playerIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (!world.field_72995_K && ElectricItem.manager.getCharge(stack = player.func_184586_b(hand)) >= (double)this.getEnergyCost(stack) && this.shouldBreak(player, world, pos)) {
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), (EntityLivingBase)player);
            Block block = world.func_180495_p(pos).func_177230_c();
            block.func_180657_a(world, player, pos, world.func_180495_p(pos), null, stack);
            world.func_175655_b(pos, false);
            world.func_175713_t(pos);
            return EnumActionResult.SUCCESS;
        }
        player.func_184609_a(hand);
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int i) {
        return Ic2Icons.getTextures((String)"gravisuit_items")[13];
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    public boolean isBasicDrill(ItemStack d) {
        return !d.func_77956_u();
    }

    public int getExtraSpeed(ItemStack d) {
        int pointBoost = this.getPointBoost(d);
        return 0 + pointBoost;
    }

    private int getPointBoost(ItemStack drill) {
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        return lvl <= 0 ? 0 : lvl * lvl + 1;
    }

    public int getExtraEnergyCost(ItemStack d) {
        int points = this.getEnergyChange(d);
        return points > 0 ? points : 0;
    }

    public int getEnergyChange(ItemStack drill) {
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        int unb = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)drill);
        int points = eff * eff + 1;
        return points -= unb * (unb + unb);
    }

    public void useDrill(ItemStack d) {
        ElectricItem.manager.use(d, (double)this.getEnergyCost(d), (EntityLivingBase)null);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            if (ElectricItem.manager.getCharge(stack) >= (double)(this.getEnergyCost(stack) * 2)) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Vajra Powered Damage", 25.0, 0));
            } else {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Vajra Unpowered Damage", 3.0, 0));
            }
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack) * 2.0, attacker);
        return true;
    }

    public boolean canMine(ItemStack d) {
        return ElectricItem.manager.canUse(d, (double)this.getEnergyCost(d));
    }

    public boolean canMineBlock(ItemStack d, IBlockState state, IBlockAccess access, BlockPos pos) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)access, (BlockPos)pos, (ItemStack)d);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

