/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.konwboy.tumbleweed.Tumbleweed;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;

@Config(modid="tumbleweed")
public class TumbleweedConfig {
    @Config.Name(value="Chance")
    @Config.Comment(value={"Chance a tumbleweed spawns in a chunk."})
    public static double spawnChance = 0.5;
    @Config.Name(value="Enable Drops")
    public static boolean enableDrops = true;
    @Config.Name(value="Damage Crops")
    @Config.Comment(value={"Should tumbleweeds damage crops."})
    public static boolean damageCrops = true;
    @Config.Name(value="Max Per Player")
    @Config.Comment(value={"Maximum number of tumbleweeds existing per player (technically 17x17 loaded chunks)."})
    public static int maxPerPlayer = 8;
    @Config.Name(value="Drops")
    @Config.Comment(value={"These items will drop from a tumbleweed upon destroying.\n<weight> <mod>:<item>:[metadata] [amount]"})
    public static String[] dropsData = Logic.access$000();
    @Config.Name(value="Spawning Blocks")
    @Config.Comment(value={"Blocks from which tumbleweeds can spawn.\n<mod>:<block>:[metadata]"})
    public static String[] spawningBlocksData = Logic.access$100();
    @Config.Name(value="Biome Whitelist")
    @Config.Comment(value={"If not empty, tumbleweeds spawn ONLY in the specified biomes. Else they appear in all hot, dry biomes.\nExample entry: minecraft:desert"})
    public static String[] biomeWhitelistData = new String[0];

    private static class WeightedItem {
        public final Metadata meta;
        public final int amount;
        public final double weight;

        public WeightedItem(Metadata meta, int amount, double weight) {
            this.meta = meta;
            this.amount = amount;
            this.weight = weight;
        }
    }

    public static class Metadata {
        public final ResourceLocation id;
        public final int meta;

        public Metadata(ResourceLocation id, int meta) {
            this.id = id;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return this.meta == metadata.meta && Objects.equal((Object)this.id, (Object)metadata.id);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.meta});
        }
    }

    public static class Logic {
        private static final String[] DEFAULT_DROPS = new String[]{"3 minecraft:bone", "3 minecraft:deadbush", "3 minecraft:string", "3 minecraft:feather", "3 minecraft:wheat", "3 minecraft:stick", "3 minecraft:reeds", "2 minecraft:melon_seeds", "2 minecraft:pumpkin_seeds", "2 minecraft:gold_nugget", "1 minecraft:name_tag", "1 minecraft:saddle", "1 minecraft:emerald", "1 minecraft:diamond", "1 minecraft:iron_ingot", "1 minecraft:gold_ingot"};
        private static final String[] DEFAULT_BLOCKS = new String[]{"minecraft:deadbush"};
        private static List<WeightedItem> weightedItems = Lists.newArrayList();
        private static int totalWeight;
        public static Set<ResourceLocation> biomeWhitelist;
        public static Set<Metadata> spawningBlocks;

        public static void reload() {
            totalWeight = 0;
            weightedItems.clear();
            biomeWhitelist.clear();
            spawningBlocks.clear();
            for (String s : dropsData) {
                String[] itemData = s.split(" ");
                if (itemData.length < 2) continue;
                double weight = Double.parseDouble(itemData[0]);
                Metadata meta = Logic.getMetadata(itemData[1]);
                if (meta == null || !Item.field_150901_e.func_148741_d((Object)meta.id)) {
                    Tumbleweed.logger.warn("Item {} is invalid.", (Object)itemData[1]);
                    continue;
                }
                int amount = 1;
                if (itemData.length >= 3) {
                    try {
                        amount = Integer.parseInt(itemData[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                weightedItems.add(new WeightedItem(Logic.getMetadata(itemData[1]), amount, weight));
                totalWeight = (int)((double)totalWeight + weight);
            }
            for (String entry : biomeWhitelistData) {
                ResourceLocation id = new ResourceLocation(entry);
                if (Biome.field_185377_q.func_148741_d((Object)id)) {
                    biomeWhitelist.add(id);
                    continue;
                }
                Tumbleweed.logger.warn("Biome {} is invalid.", (Object)id);
            }
            for (String entry : spawningBlocksData) {
                Metadata meta = Logic.getMetadata(entry);
                if (meta == null || !Block.field_149771_c.func_148741_d((Object)meta.id)) {
                    Tumbleweed.logger.warn("Block {} is invalid.", (Object)entry);
                    continue;
                }
                spawningBlocks.add(meta);
            }
        }

        public static ItemStack getRandomItem() {
            double randomWeight = (double)totalWeight * Math.random();
            double countedWeight = 0.0;
            for (WeightedItem weightedItem : weightedItems) {
                Item item;
                if ((countedWeight += weightedItem.weight) < randomWeight || (item = (Item)Item.field_150901_e.func_82594_a((Object)weightedItem.meta.id)) == null) continue;
                return new ItemStack(item, weightedItem.amount, weightedItem.meta.meta);
            }
            return null;
        }

        @Nullable
        private static Metadata getMetadata(String id) {
            String[] split = id.split(":");
            if (split.length < 2) {
                return null;
            }
            int meta = 0;
            if (split.length >= 3) {
                try {
                    meta = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Metadata(new ResourceLocation(split[0], split[1]), meta);
        }

        static /* synthetic */ String[] access$000() {
            return DEFAULT_DROPS;
        }

        static /* synthetic */ String[] access$100() {
            return DEFAULT_BLOCKS;
        }

        static {
            biomeWhitelist = Sets.newHashSet();
            spawningBlocks = Sets.newHashSet();
        }
    }
}

