/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.memory;

import java.nio.LongBuffer;
import meldexun.renderlib.util.memory.NIOBufferUtil;
import meldexun.renderlib.util.memory.PrimitiveInfo;
import meldexun.renderlib.util.memory.UnsafeNIOBuffer;

public class UnsafeLongBuffer
extends UnsafeNIOBuffer<LongBuffer> {
    public UnsafeLongBuffer(long address, long capacity) {
        super(address, PrimitiveInfo.LONG.toByte(capacity));
    }

    public long getLongCapacity() {
        return PrimitiveInfo.LONG.fromByte(this.getCapacity());
    }

    @Override
    protected LongBuffer createBuffer() {
        return NIOBufferUtil.asLongBuffer(this.getAddress(), this.getLongCapacity());
    }
}

