/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import meldexun.renderlib.util.FunctionalObject2IntMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GLShader {
    private static final IntList PROGRAM_STACK = new IntArrayList();
    private int program;
    private final FunctionalObject2IntMap<String> uniforms = new FunctionalObject2IntMap();
    private final FunctionalObject2IntMap<String> attributes = new FunctionalObject2IntMap();

    public GLShader(int program) {
        this.program = program;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void push() {
        PROGRAM_STACK.add(GL11.glGetInteger((int)35725));
    }

    public static void pop() {
        GLShader.use(PROGRAM_STACK.removeInt(PROGRAM_STACK.size() - 1));
    }

    public static void use(int program) {
        GL20.glUseProgram((int)program);
    }

    public int getProgram() {
        return this.program;
    }

    public void use() {
        GLShader.use(this.program);
    }

    public void bind() {
        GLShader.push();
        this.use();
    }

    public void unbind() {
        GLShader.pop();
    }

    public int getUniform(String uniform) {
        return this.uniforms.computeIfAbsent(uniform, k -> GL20.glGetUniformLocation((int)this.program, (CharSequence)k));
    }

    public int getAttribute(String attribute) {
        return this.attributes.computeIfAbsent(attribute, k -> GL20.glGetAttribLocation((int)this.program, (CharSequence)k));
    }

    public void dispose() {
        GL20.glDeleteProgram((int)this.program);
        this.program = -1;
    }

    public static class Builder {
        private final Int2ObjectMap<Supplier<String>> shaderMap = new Int2ObjectOpenHashMap();
        private final Object2IntMap<String> attributeMap = new Object2IntOpenHashMap();

        public Builder addShader(int type, Supplier<String> source) {
            this.shaderMap.put(type, source);
            return this;
        }

        public Builder bindAttribute(String attribute, int index) {
            this.attributeMap.put((Object)attribute, index);
            return this;
        }

        public GLShader build() {
            int program = GL20.glCreateProgram();
            IntArrayList shaderList = new IntArrayList();
            for (Int2ObjectMap.Entry entry : this.shaderMap.int2ObjectEntrySet()) {
                int shader2 = GL20.glCreateShader((int)entry.getIntKey());
                GL20.glShaderSource((int)shader2, (CharSequence)((CharSequence)((Supplier)entry.getValue()).get()));
                GL20.glCompileShader((int)shader2);
                int compileStatus = GL20.glGetShaderi((int)shader2, (int)35713);
                if (compileStatus != 1) {
                    int logLength = GL20.glGetShaderi((int)shader2, (int)35716);
                    String shaderInfoLog = GL20.glGetShaderInfoLog((int)shader2, (int)logLength);
                    throw new RuntimeException(String.format("Failed to compile shader: %d%n%s", compileStatus, shaderInfoLog));
                }
                shaderList.add(shader2);
            }
            shaderList.forEach(shader -> GL20.glAttachShader((int)program, (int)shader));
            this.attributeMap.forEach((attribute, index) -> GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)attribute));
            GL20.glLinkProgram((int)program);
            int linkStatus = GL20.glGetProgrami((int)program, (int)35714);
            if (linkStatus != 1) {
                int logLength = GL20.glGetProgrami((int)program, (int)35716);
                String programInfoLog = GL20.glGetProgramInfoLog((int)program, (int)logLength);
                throw new RuntimeException(String.format("Failed to link program: %d%n%s", linkStatus, programInfoLog));
            }
            shaderList.forEach(GL20::glDeleteShader);
            return new GLShader(program);
        }

        public GLShader build(Consumer<GLShader> callback) {
            GLShader shader = this.build();
            GLShader.push();
            shader.use();
            callback.accept(shader);
            GLShader.pop();
            return shader;
        }
    }
}

