/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import java.nio.ByteBuffer;
import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.api.IBoundingBoxCache;
import meldexun.renderlib.util.EntityUtil;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.MutableAABB;
import meldexun.renderlib.util.RenderUtil;
import meldexun.renderlib.util.ResourceSupplier;
import meldexun.renderlib.util.TileEntityUtil;
import meldexun.renderlib.util.memory.NIOBufferUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class BoundingBoxHelper {
    private static final byte[] VERTEX_DATA = new byte[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1};
    private static final byte[] INDICES = new byte[]{0, 4, 5, 1, 3, 7, 6, 2, 4, 0, 2, 6, 1, 5, 7, 3, 0, 1, 3, 2, 5, 4, 6, 7};
    private static final String A_POS = "a_Pos";
    private static final String U_MATRIX = "u_ModelViewProjectionMatrix";
    private static BoundingBoxHelper instance;
    private final GLShader shader = GLShader.builder().addShader(35633, new ResourceSupplier(new ResourceLocation("renderlib", "shaders/debug.vsh"))).addShader(35632, new ResourceSupplier(new ResourceLocation("renderlib", "shaders/debug.fsh"))).bindAttribute("a_Pos", 0).build();
    private final int cubeVertexBuffer = GL15.glGenBuffers();
    private final int quadsCubeIndexBuffer;

    public BoundingBoxHelper() {
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        NIOBufferUtil.tempByteBuffer(VERTEX_DATA, buffer -> GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)35044));
        GL15.glBindBuffer((int)34962, (int)0);
        this.quadsCubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.quadsCubeIndexBuffer);
        NIOBufferUtil.tempByteBuffer(INDICES, buffer -> GL15.glBufferData((int)34963, (ByteBuffer)buffer, (int)35044));
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public static BoundingBoxHelper getInstance() {
        if (instance == null) {
            instance = new BoundingBoxHelper();
        }
        return instance;
    }

    public void drawRenderBoxes(double partialTicks) {
        this.setupRenderState();
        GLShader.push();
        this.shader.use();
        GL15.glBindBuffer((int)34963, (int)this.quadsCubeIndexBuffer);
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_POS), (int)3, (int)5120, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        Minecraft mc = Minecraft.func_71410_x();
        EntityUtil.entityIterable(mc.field_71441_e.field_72996_f).forEach(entity -> {
            if (entity == mc.func_175606_aa()) {
                return;
            }
            MutableAABB aabb = ((IBoundingBoxCache)entity).getCachedBoundingBox();
            if (!aabb.isVisible(RenderUtil.getFrustum())) {
                return;
            }
            Matrix4f matrix = RenderUtil.getProjectionModelViewMatrix().copy();
            matrix.translate((float)(aabb.minX() - RenderUtil.getCameraEntityX()), (float)(aabb.minY() - RenderUtil.getCameraEntityY()), (float)(aabb.minZ() - RenderUtil.getCameraEntityZ()));
            matrix.scale((float)aabb.sizeX(), (float)aabb.sizeY(), (float)aabb.sizeZ());
            GLUtil.setMatrix(this.shader.getUniform(U_MATRIX), matrix);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6914);
        });
        TileEntityUtil.processTileEntities((World)mc.field_71441_e, tileEntity -> {
            MutableAABB aabb = ((IBoundingBoxCache)tileEntity).getCachedBoundingBox();
            if (!aabb.isVisible(RenderUtil.getFrustum())) {
                return;
            }
            Matrix4f matrix = RenderUtil.getProjectionModelViewMatrix().copy();
            matrix.translate((float)(aabb.minX() - RenderUtil.getCameraEntityX()), (float)(aabb.minY() - RenderUtil.getCameraEntityY()), (float)(aabb.minZ() - RenderUtil.getCameraEntityZ()));
            matrix.scale((float)aabb.sizeX(), (float)aabb.sizeY(), (float)aabb.sizeZ());
            GLUtil.setMatrix(this.shader.getUniform(U_MATRIX), matrix);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6914);
        });
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        GLShader.pop();
        this.clearRenderState();
    }

    private void setupRenderState() {
        GLUtil.saveShaderGLState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179129_p();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void clearRenderState() {
        GLUtil.restoreShaderGLState();
    }
}

