/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.renderer.entity;

import java.util.ArrayDeque;
import java.util.Deque;
import meldexun.renderlib.RenderLib;
import meldexun.renderlib.api.IEntityRendererCache;
import meldexun.renderlib.api.ILoadable;
import meldexun.renderlib.integration.FairyLights;
import meldexun.renderlib.integration.Vampirism;
import meldexun.renderlib.renderer.entity.EntityRenderList;
import meldexun.renderlib.util.EntityUtil;
import meldexun.renderlib.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;

public class EntityRenderer {
    protected int renderedEntities;
    protected int occludedEntities;
    protected int totalEntities;
    private int camChunkX;
    private int camChunkZ;
    private int renderDist;
    private final Deque<EntityRenderList> entityListQueue = new ArrayDeque<EntityRenderList>();

    public void setup(ICamera frustum, float partialTicks, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.func_71410_x();
        this.renderedEntities = 0;
        this.occludedEntities = 0;
        this.totalEntities = mc.field_71441_e.field_72996_f.size();
        this.camChunkX = MathHelper.func_76128_c((double)RenderUtil.getCameraEntityX()) >> 4;
        this.camChunkZ = MathHelper.func_76128_c((double)RenderUtil.getCameraEntityZ()) >> 4;
        this.renderDist = mc.field_71474_y.field_151451_c;
        EntityRenderList entityList = new EntityRenderList();
        for (Entity entity : EntityUtil.entityIterable(mc.field_71441_e.field_72996_f)) {
            if (!this.shouldRender(entity, frustum, partialTicks, camX, camY, camZ)) continue;
            if (this.isOcclusionCulled(entity)) {
                ++this.occludedEntities;
                if (RenderLib.isVampirismInstalled && entity instanceof EntityLivingBase) {
                    Vampirism.onRenderLivingPost((EntityLivingBase)entity);
                }
            } else {
                ++this.renderedEntities;
                entityList.addEntity(entity);
                if (((IEntityRendererCache)entity).getRenderer().func_188295_H_()) {
                    entityList.addMultipassEntity(entity);
                }
            }
            if (!this.shouldRenderOutlines(entity)) continue;
            entityList.addOutlineEntity(entity);
        }
        this.entityListQueue.addLast(entityList);
    }

    public void reset() {
        this.entityListQueue.removeLast();
    }

    public void renderEntities(float partialTicks) {
        this.renderEntities(partialTicks, this.entityListQueue.getLast());
    }

    protected void renderEntities(float partialTicks, EntityRenderList entityList) {
        Minecraft mc = Minecraft.func_71410_x();
        for (Entity entity : entityList.getEntities()) {
            this.preRenderEntity(entity);
            mc.func_175598_ae().func_188388_a(entity, partialTicks, false);
            this.postRenderEntity();
        }
        for (Entity entity : entityList.getMultipassEntities()) {
            this.preRenderEntity(entity);
            mc.func_175598_ae().func_188389_a(entity, partialTicks);
            this.postRenderEntity();
        }
        if (MinecraftForgeClient.getRenderPass() == 0 && this.isRenderEntityOutlines() && (!entityList.getOutlineEntities().isEmpty() || mc.field_71438_f.field_184386_ad)) {
            mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
            mc.field_71438_f.field_175015_z.func_147614_f();
            boolean bl = mc.field_71438_f.field_184386_ad = !entityList.getOutlineEntities().isEmpty();
            if (!entityList.getOutlineEntities().isEmpty()) {
                GlStateManager.func_179143_c((int)519);
                GlStateManager.func_179106_n();
                mc.field_71438_f.field_175015_z.func_147610_a(false);
                RenderHelper.func_74518_a();
                mc.func_175598_ae().func_178632_c(true);
                for (Entity entity : entityList.getOutlineEntities()) {
                    this.preRenderEntity(entity);
                    mc.func_175598_ae().func_188388_a(entity, partialTicks, false);
                    this.postRenderEntity();
                }
                mc.func_175598_ae().func_178632_c(false);
                RenderHelper.func_74519_b();
                GlStateManager.func_179132_a((boolean)false);
                mc.field_71438_f.field_174991_A.func_148018_a(partialTicks);
                GlStateManager.func_179145_e();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179127_m();
                GlStateManager.func_179147_l();
                GlStateManager.func_179142_g();
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
            }
            mc.func_147110_a().func_147610_a(false);
        }
    }

    private boolean shouldRender(Entity entity, ICamera frustum, double partialTicks, double camX, double camY, double camZ) {
        if (!((IEntityRendererCache)entity).hasRenderer()) {
            return false;
        }
        if (!((ILoadable)entity).isChunkLoaded()) {
            return false;
        }
        if (!entity.shouldRenderInPass(0) && !entity.shouldRenderInPass(1)) {
            return false;
        }
        if (this.isOutsideOfRenderDist(entity, partialTicks)) {
            return false;
        }
        if (!(((IEntityRendererCache)entity).getRenderer().func_177071_a(entity, frustum, camX, camY, camZ) || entity.func_184215_y((Entity)Minecraft.func_71410_x().field_71439_g) || RenderLib.isFairyLightsInstalled && FairyLights.isFairyLightEntity(entity))) {
            this.setCanBeOcclusionCulled(entity, false);
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O == 0 && entity == mc.func_175606_aa() && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70608_bn()) {
            this.setCanBeOcclusionCulled(entity, false);
            return false;
        }
        this.setCanBeOcclusionCulled(entity, true);
        return true;
    }

    private boolean isOutsideOfRenderDist(Entity entity, double partialTicks) {
        int entityX = MathHelper.func_76128_c((double)(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * partialTicks)) >> 4;
        if (Math.abs(entityX - this.camChunkX) > this.renderDist) {
            return true;
        }
        int entityZ = MathHelper.func_76128_c((double)(entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * partialTicks)) >> 4;
        return Math.abs(entityZ - this.camChunkZ) > this.renderDist;
    }

    protected <T extends Entity> void setCanBeOcclusionCulled(T entity, boolean canBeOcclusionCulled) {
    }

    protected <T extends Entity> boolean isOcclusionCulled(T entity) {
        return false;
    }

    protected boolean shouldRenderOutlines(Entity entity) {
        if (entity.func_184202_aL()) {
            return true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (!mc.field_71474_y.field_178883_an.func_151470_d()) {
            return false;
        }
        return entity instanceof EntityPlayer;
    }

    protected void preRenderEntity(Entity entity) {
        entity.shouldRenderInPass(MinecraftForgeClient.getRenderPass());
    }

    protected void postRenderEntity() {
    }

    protected boolean isRenderEntityOutlines() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71438_f.field_175015_z != null && mc.field_71438_f.field_174991_A != null;
    }

    public int getRenderedEntities() {
        return this.renderedEntities;
    }

    public int getOccludedEntities() {
        return this.occludedEntities;
    }

    public int getTotalEntities() {
        return this.totalEntities;
    }
}

