/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public final class MatrixHelpers {
    private static final Matrix4f IDENTITY = new Matrix4f();
    private static final Matrix4f[] FACINGS = new Matrix4f[EnumFacing.field_82609_l.length];

    private MatrixHelpers() {
    }

    public static Matrix4f matrixFor(EnumFacing facing) {
        int index = facing.ordinal();
        return index < FACINGS.length ? FACINGS[index] : IDENTITY;
    }

    public static AxisAlignedBB transform(AxisAlignedBB box, Matrix4f matrix) {
        return new AxisAlignedBB((double)((float)((double)matrix.m00 * box.field_72340_a + (double)matrix.m01 * box.field_72338_b + (double)matrix.m02 * box.field_72339_c + (double)matrix.m03)), (double)((float)((double)matrix.m10 * box.field_72340_a + (double)matrix.m11 * box.field_72338_b + (double)matrix.m12 * box.field_72339_c + (double)matrix.m13)), (double)((float)((double)matrix.m20 * box.field_72340_a + (double)matrix.m21 * box.field_72338_b + (double)matrix.m22 * box.field_72339_c + (double)matrix.m23)), (double)((float)((double)matrix.m00 * box.field_72336_d + (double)matrix.m01 * box.field_72337_e + (double)matrix.m02 * box.field_72334_f + (double)matrix.m03)), (double)((float)((double)matrix.m10 * box.field_72336_d + (double)matrix.m11 * box.field_72337_e + (double)matrix.m12 * box.field_72334_f + (double)matrix.m13)), (double)((float)((double)matrix.m20 * box.field_72336_d + (double)matrix.m21 * box.field_72337_e + (double)matrix.m22 * box.field_72334_f + (double)matrix.m23)));
    }

    static {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int y;
            int x;
            switch (facing) {
                default: {
                    x = 0;
                    y = 0;
                    break;
                }
                case UP: {
                    x = 180;
                    y = 0;
                    break;
                }
                case EAST: {
                    x = 90;
                    y = 270;
                    break;
                }
                case WEST: {
                    x = 90;
                    y = 90;
                    break;
                }
                case NORTH: {
                    x = 90;
                    y = 180;
                    break;
                }
                case SOUTH: {
                    x = 90;
                    y = 0;
                }
            }
            Matrix4f result = new Matrix4f();
            Matrix4f temp = new Matrix4f();
            result.setIdentity();
            temp.setIdentity();
            temp.setTranslation(new Vector3f(0.5f, 0.5f, 0.5f));
            result.mul(temp);
            temp.setIdentity();
            temp.rotY((float)(-y) / 180.0f * (float)Math.PI);
            result.mul(temp);
            temp.setIdentity();
            temp.rotX((float)(-x) / 180.0f * (float)Math.PI);
            result.mul(temp);
            temp.setIdentity();
            temp.setTranslation(new Vector3f(-0.5f, -0.5f, -0.5f));
            result.mul(temp);
            MatrixHelpers.FACINGS[facing.ordinal()] = result;
        }
    }
}

