/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.util.IDAssigner;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.PlethoraCore;

public final class Helpers {
    public static final Random RANDOM = new Random();
    private static final Set<String> blacklistedMods = new HashSet<String>();

    private Helpers() {
    }

    public static String translateAny(String ... strings) {
        return Helpers.translateOrDefault(strings[strings.length - 1], strings);
    }

    public static String translateOrDefault(String def, String ... strings) {
        for (String string : strings) {
            if (!I18n.func_94522_b((String)string)) continue;
            return I18n.func_74838_a((String)string);
        }
        return def;
    }

    public static String translateToLocal(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static String translateToLocalFormatted(String format, Object ... args) {
        return I18n.func_74837_a((String)format, (Object[])args);
    }

    public static String swapCharacters(String word, char a, char b) {
        StringBuilder builder = new StringBuilder(word.length());
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c == a) {
                c = b;
            } else if (c == b) {
                c = a;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static int nextId(World world, String type) {
        return IDAssigner.getNextIDFromFile((String)("computer/lastid_" + type + ".txt"));
    }

    public static int nextId(World world, IPeripheral peripheral) {
        return Helpers.nextId(world, peripheral.getType());
    }

    public static String snakeCase(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupModel(Item item, int damage, String name) {
        name = "plethora:" + Helpers.snakeCase(name);
        ModelResourceLocation res = new ModelResourceLocation(name, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)damage, (ModelResourceLocation)res);
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float dX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float dY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float dZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        EntityItem entity = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, stack);
        float motion = 0.05f;
        entity.field_70159_w = RANDOM.nextGaussian() * (double)motion;
        entity.field_70181_x = RANDOM.nextGaussian() * (double)motion + (double)0.2f;
        entity.field_70179_y = RANDOM.nextGaussian() * (double)motion;
        world.func_72838_d((Entity)entity);
    }

    public static Set<String> getContainingMods(File file) {
        HashSet<String> modIds = new HashSet<String>();
        for (ModContainer container : Loader.instance().getModList()) {
            if (!container.getSource().equals(file)) continue;
            modIds.add(container.getModId());
        }
        return modIds;
    }

    public static File getContainingJar(Class<?> klass) {
        File file;
        URL url;
        String path = klass.getProtectionDomain().getCodeSource().getLocation().getPath();
        int bangIndex = path.indexOf(33);
        if (bangIndex >= 0) {
            path = path.substring(0, bangIndex);
        }
        try {
            url = new URL(path);
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException ignored) {
            file = new File(url.getPath());
        }
        return file;
    }

    public static boolean blacklisted(Iterable<String> blacklist, String name) {
        for (String prefix : blacklist) {
            if (!name.startsWith(prefix)) continue;
            if (name.length() == prefix.length()) {
                return true;
            }
            char last = prefix.charAt(prefix.length() - 1);
            if (last == '.' || last == '#' || last == '$') {
                return true;
            }
            char next = name.charAt(prefix.length());
            if (next != '.' && next != '#' && next != '$' && next != '(') continue;
            return true;
        }
        return false;
    }

    public static boolean modLoaded(String mod) {
        return (Loader.isModLoaded((String)mod) || ModAPIManager.INSTANCE.hasAPI(mod)) && !ConfigCore.Blacklist.blacklistMods.contains(mod) && !blacklistedMods.contains(mod);
    }

    public static void blacklistMod(String mod) {
        blacklistedMods.add(mod);
    }

    @Nonnull
    public static String getName(Entity entity) {
        String name = EntityList.func_75621_b((Entity)entity);
        if (name == null) {
            if (entity instanceof EntityPlayer) {
                return entity.func_70005_c_();
            }
            if (entity.func_145818_k_()) {
                return entity.func_95999_t();
            }
            return "unknown";
        }
        return name;
    }

    public static String getName(ItemStack stack) {
        String name = stack.func_77977_a();
        if (!Strings.isNullOrEmpty((String)name)) {
            name = StringUtils.removeStart((String)name, (String)"tile.");
            name = StringUtils.removeStart((String)name, (String)"item.");
            name = StringUtils.removeEnd((String)name, (String)".name");
            return name;
        }
        return stack.func_77973_b().getRegistryName().toString();
    }

    @Nonnull
    public static String getName(Object owner) {
        if (owner == null) {
            return "null";
        }
        if (owner instanceof ItemStack) {
            return Helpers.getName((ItemStack)owner);
        }
        if (owner instanceof Item) {
            return ((Item)owner).getRegistryName().toString();
        }
        if (owner instanceof Entity) {
            return Helpers.getName((Entity)owner);
        }
        if (owner instanceof Block) {
            return ((Block)owner).getRegistryName().toString();
        }
        if (owner instanceof TileEntity) {
            TileEntity te = (TileEntity)owner;
            ResourceLocation name = (ResourceLocation)TileEntity.field_190562_f.func_177774_c(te.getClass());
            if (name != null) {
                return name.toString();
            }
            Block block = te.func_145838_q();
            int meta = te.func_145832_p();
            return block != null ? Helpers.getName(new ItemStack(block, 1, meta)) : te.getClass().getSimpleName();
        }
        return owner.getClass().getSimpleName();
    }

    @Nonnull
    public static String tryGetName(Object owner) {
        try {
            return Helpers.getName(owner);
        }
        catch (Throwable e) {
            PlethoraCore.LOG.error("Error getting data for " + owner.getClass().getName(), e);
            return owner.getClass().getSimpleName();
        }
    }

    public static boolean onEntityInteract(Item item, EntityPlayer player, Entity target, EnumHand hand) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        ItemStack current = player.func_184586_b(hand);
        if (current.func_190926_b() || current.func_77973_b() != item) {
            return false;
        }
        boolean result = item.func_111207_a(current, player, (EntityLivingBase)target, hand);
        if (current.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)current, (EnumHand)hand);
        }
        return result;
    }

    public static void assertTarget(Class<?> klass, Class<?> target, Class<?> iface) {
        TypeToken initial = TypeToken.of(klass);
        TypeToken.TypeSet collection = iface.isInterface() ? initial.getTypes().interfaces() : initial.getTypes().classes();
        List allTargets = null;
        for (TypeToken tok : collection) {
            Type[] args;
            if (tok.getRawType() != iface || !(tok.getType() instanceof ParameterizedType) || (args = ((ParameterizedType)tok.getType()).getActualTypeArguments()).length == 0) continue;
            Type arg = args[0];
            if (arg == target) {
                return;
            }
            if (allTargets == null) {
                allTargets = Lists.newArrayList();
            }
            allTargets.add(arg);
        }
        if (allTargets != null) {
            boolean valid = false;
            for (Type arg : allTargets) {
                if (arg instanceof Class && ((Class)arg).isAssignableFrom(target)) {
                    PlethoraCore.LOG.warn("Specified target as " + target.getName() + " but got superclass" + arg + " for " + klass.getName());
                    valid |= !ConfigCore.Testing.strict;
                    continue;
                }
                if (!(arg instanceof TypeVariable)) continue;
                TypeVariable var = (TypeVariable)arg;
                for (Type bound : var.getBounds()) {
                    if (!(bound instanceof Class) || !((Class)bound).isAssignableFrom(target)) continue;
                    PlethoraCore.LOG.warn("Specified target as " + target.getName() + " but got generic parameter with matching bound " + var.getName() + " extends " + ((Class)bound).getName() + " for " + klass.getName());
                    valid |= !ConfigCore.Testing.strict;
                }
            }
            if (valid) {
                return;
            }
        }
        String message = "Annotation target " + target.getName() + " does not match type parameters";
        message = message + (allTargets == null ? " (cannot find any type parameters)" : " (specified parameters are " + allTargets + ")");
        if (ConfigCore.Testing.strict) {
            throw new IllegalStateException(message);
        }
        PlethoraCore.LOG.error(message);
    }

    private static int hashStack(@Nonnull ItemStack stack) {
        int hash = stack.func_77973_b().hashCode() * 31 + stack.func_77952_i();
        if (stack.func_77942_o()) {
            hash = hash * 31 + stack.func_77978_p().hashCode();
        }
        return hash;
    }

    public static int hashStacks(Iterable<ItemStack> stacks) {
        int hash = 0;
        for (ItemStack stack : stacks) {
            hash *= 31;
            if (stack.func_190926_b()) continue;
            hash += Helpers.hashStack(stack);
        }
        return hash;
    }

    public static boolean isHolding(EntityLivingBase entity, Item item) {
        ItemStack left = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (!left.func_190926_b() && left.func_77973_b() == item) {
            return true;
        }
        ItemStack right = entity.func_184586_b(EnumHand.OFF_HAND);
        return !right.func_190926_b() && right.func_77973_b() == item;
    }

    public static boolean isHolding(EntityLivingBase entity, Item item, int damage) {
        ItemStack left = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (!left.func_190926_b() && left.func_77973_b() == item && left.func_77952_i() == damage) {
            return true;
        }
        ItemStack right = entity.func_184586_b(EnumHand.OFF_HAND);
        return !right.func_190926_b() && right.func_77973_b() == item && right.func_77952_i() == damage;
    }
}

