/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.ITransferMethod;
import org.squiddev.plethora.api.method.MarkerInterfaces;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public final class MethodsInventoryTransfer {
    private MethodsInventoryTransfer() {
    }

    @PlethoraMethod(doc="-- Push items from this inventory to another inventory. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static int pushItems(IContext<IItemHandler> context, String toName, int fromSlot, @Optional(defInt=0x7FFFFFFF) int limit, @Optional int toSlot) throws LuaException {
        IItemHandler from = (IItemHandler)context.getTarget();
        Object location = context.getTransferLocation(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = MethodsInventoryTransfer.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        ArgumentHelper.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot != -1) {
            ArgumentHelper.assertBetween(toSlot, 1, to.getSlots(), "To slot out of range (%s)");
        }
        return MethodsInventoryTransfer.moveItem(from, fromSlot - 1, to, toSlot - 1, limit);
    }

    @PlethoraMethod(doc="-- Pull items to this inventory from another inventory. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static int pullItems(IContext<IItemHandler> context, String fromName, int fromSlot, @Optional(defInt=0x7FFFFFFF) int limit, @Optional int toSlot) throws LuaException {
        IItemHandler to = (IItemHandler)context.getTarget();
        Object location = context.getTransferLocation(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = MethodsInventoryTransfer.extractHandler(location);
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        ArgumentHelper.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot != -1) {
            ArgumentHelper.assertBetween(toSlot, 1, to.getSlots(), "To slot out of range (%s)");
        }
        return MethodsInventoryTransfer.moveItem(from, fromSlot - 1, to, toSlot - 1, limit);
    }

    @Nullable
    public static IItemHandler extractHandler(@Nonnull Object object) {
        for (Object child : PlethoraAPI.instance().converterRegistry().convertAll(object)) {
            IItemHandler handler;
            if (child instanceof IItemHandler) {
                return (IItemHandler)child;
            }
            if (!(object instanceof ICapabilityProvider) || (handler = (IItemHandler)((ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
            return handler;
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int extractCount = Math.min(extracted.func_190916_E(), limit);
        extracted.func_190920_e(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int insertCount = remainder.func_190926_b() ? extractCount : extractCount - remainder.func_190916_E();
        from.extractItem(fromSlot, insertCount, false);
        return insertCount;
    }
}

