/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla;

import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.module.BasicModuleHandler;
import org.squiddev.plethora.api.module.IModuleRegistry;
import org.squiddev.plethora.api.vehicle.VehicleModuleHandler;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.modules.BasicModuleHandlerTransform;
import org.squiddev.plethora.core.modules.VehicleModuleHandlerTransform;
import org.squiddev.plethora.integration.vanilla.DisableAI;

@Mod.EventBusSubscriber(modid="plethora-core")
public final class IntegrationVanilla {
    public static final String daylightSensor = "minecraft:daylight_detector";
    public static final String clock = "minecraft:clock";
    public static final String noteblock = "minecraft:noteblock";
    public static final ResourceLocation daylightSensorMod = new ResourceLocation("minecraft:daylight_detector");
    public static final ResourceLocation clockMod = new ResourceLocation("minecraft:clock");
    public static final ResourceLocation noteblockMod = new ResourceLocation("minecraft:noteblock");
    private static final BasicModuleHandler daylightSensorHandlerModel = new BasicModuleHandlerTransform(daylightSensorMod, Item.func_150898_a((Block)Blocks.field_150453_bW), new Matrix4f(0.0f, 0.6f, 0.0f, 0.2f, 0.0f, 0.0f, 0.6f, -0.1f, 0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
    private static final BasicModuleHandler noteblockHandlerModel = new BasicModuleHandlerTransform(noteblockMod, Item.func_150898_a((Block)Blocks.field_150323_B), new Matrix4f(0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6f, 0.0f, -0.1f, 0.0f, 0.0f, 0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
    private static final VehicleModuleHandler daylightSensorCap = new VehicleModuleHandlerTransform(daylightSensorMod, Item.func_150898_a((Block)Blocks.field_150453_bW), new Matrix4f(0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.6f, 0.0f, 0.0f, 0.6f, 0.0f, 0.2f, 0.0f, 0.0f, 0.0f, 1.0f));
    private static final VehicleModuleHandler clockCap = new VehicleModuleHandler(clockMod, Items.field_151113_aN);
    private static final VehicleModuleHandler noteblockCap = new VehicleModuleHandlerTransform(noteblockMod, Item.func_150898_a((Block)Blocks.field_150323_B), new Matrix4f(0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));

    private IntegrationVanilla() {
    }

    public static void setup() {
        DisableAI.register();
        IModuleRegistry registry = PlethoraAPI.instance().moduleRegistry();
        registry.registerPocketUpgrade(new ItemStack(Items.field_151113_aN), "adjective.plethora.clock");
        registry.registerTurtleUpgrade(new ItemStack(Items.field_151113_aN), "adjective.plethora.clock");
        registry.registerPocketUpgrade(new ItemStack((Block)Blocks.field_150453_bW), "adjective.plethora.daylight_detector");
        registry.registerTurtleUpgrade(new ItemStack((Block)Blocks.field_150453_bW), daylightSensorHandlerModel, "adjective.plethora.daylight_detector");
        registry.registerPocketUpgrade(new ItemStack(Blocks.field_150323_B), "adjective.plethora.note_block");
        registry.registerTurtleUpgrade(new ItemStack(Blocks.field_150323_B), noteblockHandlerModel, "adjective.plethora.note_block");
    }

    @SubscribeEvent
    public static void attachCapabilitiesItem(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).func_77973_b();
        if (item == Items.field_151113_aN) {
            event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)clockCap);
        } else if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            if (block == Blocks.field_150453_bW) {
                event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)daylightSensorCap);
            } else if (block == Blocks.field_150323_B) {
                event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)noteblockCap);
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilitiesTile(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity entity = (TileEntity)event.getObject();
        if (entity instanceof TileEntityNote) {
            event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)noteblockCap);
        } else if (entity instanceof TileEntityDaylightDetector) {
            event.addCapability(PlethoraCore.PERIPHERAL_HANDLER_KEY, (ICapabilityProvider)daylightSensorCap);
        }
    }

    @SubscribeEvent
    public static void attachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityLiving) {
            event.addCapability(DisableAI.DISABLE_AI, (ICapabilityProvider)new DisableAI.DefaultDisableAI((EntityLiving)entity));
        }
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingUpdateEvent event) {
        DisableAI.IDisableAIHandler handler;
        EntityLivingBase livingBase = event.getEntityLiving();
        if (livingBase instanceof EntityLiving && (handler = (DisableAI.IDisableAIHandler)livingBase.getCapability(DisableAI.DISABLE_AI_CAPABILITY, null)) != null) {
            handler.func_73660_a();
        }
    }
}

