/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.integration.jei.UseInRecipeCategory;
import org.squiddev.plethora.integration.jei.UseInRecipeWrapper;

public final class PeripheralsWrapper
extends UseInRecipeWrapper {
    private static final String ID = "peripherals";
    private static final ItemStack[] STACKS = new ItemStack[]{new ItemStack((Item)Registration.itemNeuralInterface)};

    private PeripheralsWrapper(@Nonnull ItemStack stack, @Nonnull IGuiHelper helper) {
        super(stack, ID, STACKS, helper);
    }

    @Override
    public boolean isValid() {
        return PeripheralsWrapper.isValid(this.stack);
    }

    private static boolean isValid(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.hasCapability(Constants.PERIPHERAL_CAPABILITY, null) || stack.hasCapability(Constants.PERIPHERAL_HANDLER_CAPABILITY, null);
    }

    public static void setup(IModRegistry registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        ArrayList wrappers = Lists.newArrayList();
        for (ItemStack stack : registry.getIngredientRegistry().getAllIngredients(VanillaTypes.ITEM)) {
            if (!PeripheralsWrapper.isValid(stack)) continue;
            wrappers.add(new PeripheralsWrapper(stack, helper));
        }
        registry.addRecipes((Collection)wrappers, "plethora-core:peripherals");
        for (ItemStack stack : STACKS) {
            registry.addRecipeCatalyst((Object)stack, new String[]{"plethora-core:peripherals"});
        }
    }

    public static void setup(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new UseInRecipeCategory(ID, registry.getJeiHelpers().getGuiHelper())});
    }
}

