/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.ic2;

import ic2.api.energy.prefab.BasicSinkSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.utils.WorldDummy;

@Injects(value="ic2")
public final class MetaEnergyTile
extends BasicMetaProvider<IEnergyTile> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IEnergyTile object) {
        HashMap<String, Number> out = new HashMap<String, Number>();
        if (object instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)object;
            out.put("sinkTier", sink.getSinkTier());
            out.put("demandedEnergy", sink.getDemandedEnergy());
        }
        if (object instanceof IEnergyConductor) {
            IEnergyConductor conductor = (IEnergyConductor)object;
            out.put("conductionLoss", conductor.getConductionLoss());
            out.put("conductorBreakdownEnergy", conductor.getConductorBreakdownEnergy());
            out.put("insulationBreakdownEnergy", conductor.getInsulationBreakdownEnergy());
            out.put("insulationEnergyAbsorption", conductor.getInsulationEnergyAbsorption());
        }
        if (object instanceof IEnergySource) {
            IEnergySource source = (IEnergySource)object;
            out.put("sourceTier", source.getSourceTier());
            out.put("offeredEnergy", source.getOfferedEnergy());
        }
        return Collections.singletonMap("eu", out);
    }

    @Override
    @Nonnull
    public IEnergyTile getExample() {
        return new BasicSinkSource(WorldDummy.INSTANCE, BlockPos.field_177992_a, 1000.0, 3, 2){

            public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
                return true;
            }

            public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
                return true;
            }
        };
    }
}

