/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.forestry;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.integration.forestry.MetaGenome;

@Injects(value="forestry")
public final class MetaMutation
extends BasicMetaProvider<IMutation> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IMutation mutation) {
        HashMap<String, Object> out = new HashMap<String, Object>(5);
        out.put("species1", mutation.getAllele0().getUID());
        out.put("species2", mutation.getAllele1().getUID());
        out.put("chance", Float.valueOf(mutation.getBaseChance()));
        IChromosomeType[] karyotype = mutation.getRoot().getKaryotype();
        HashMap<String, Object> results = new HashMap<String, Object>(karyotype.length);
        for (IChromosomeType chromosome : karyotype) {
            for (IAllele allele : mutation.getTemplate()) {
                if (!chromosome.getAlleleClass().isInstance(allele)) continue;
                results.put(chromosome.getName(), MetaGenome.getAlleleMeta(allele));
            }
        }
        out.put("result", results);
        HashMap<Integer, String> conditions = new HashMap<Integer, String>(mutation.getSpecialConditions().size());
        int i = 0;
        for (String condition : mutation.getSpecialConditions()) {
            conditions.put(++i, condition);
        }
        if (!conditions.isEmpty()) {
            out.put("conditions", conditions);
        }
        return out;
    }

    @Override
    @Nullable
    public IMutation getExample() {
        ISpeciesRoot root = BeeDefinition.FOREST.getGenome().getSpeciesRoot();
        List mutation = root.getMutations(false);
        return mutation.isEmpty() ? null : (IMutation)mutation.get(0);
    }
}

