/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.extrautilities;

import com.rwtema.extrautils2.items.ItemGoldenLasso;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;

@Injects(value="extrautils2")
public final class IntegrationExtraUtilities {
    public static final IMetaProvider<ItemStack> META_MONSTER_NET = new ItemEntityStorageMetaProvider<ItemGoldenLasso>("capturedEntity", ItemGoldenLasso.class, "Provides the entity captured inside this lasso."){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull ItemGoldenLasso item, @Nonnull IWorldLocation location) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !tag.func_150297_b("Animal", 10)) {
                return null;
            }
            NBTTagCompound entityData = tag.func_74775_l("Animal");
            if (!entityData.func_150297_b("id", 8)) {
                return null;
            }
            return EntityList.func_75615_a((NBTTagCompound)entityData, (World)location.getWorld());
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull ItemGoldenLasso item) {
            return 1.getBasicDetails(stack.func_77978_p());
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return ItemGoldenLasso.newCraftingStack(EntitySquid.class);
        }
    };

    private IntegrationExtraUtilities() {
    }
}

